/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.alert;

import java.util.Objects;
import nextapp.echo2.app.Color;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.lookup.Lookup;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.web.echo.colour.ColourHelper;
import org.openvpms.web.system.ServiceHelper;

public class Alert
implements Comparable<Alert> {
    private final IMObject alertType;
    private Act alert;
    private Priority priority;
    private String priorityCode;
    private Color colour;
    private IMObjectBean bean;

    public Alert(IMObject alertType) {
        this(alertType, null);
    }

    public Alert(IMObject alertType, Act alert) {
        this.alertType = alertType;
        this.alert = alert;
    }

    public IMObject getAlertType() {
        return this.alertType;
    }

    public Act getAlert() {
        return this.alert;
    }

    public String getName() {
        return this.alertType.getName();
    }

    public Color getColour() {
        if (this.colour == null) {
            this.colour = ColourHelper.getColor((String)this.getBean().getString("colour"));
        }
        return this.colour;
    }

    public Color getTextColour() {
        Color color = this.getColour();
        return color != null ? ColourHelper.getTextColour((Color)color) : null;
    }

    public Priority getPriority() {
        if (this.priority == null) {
            this.priority = new Priority(this.getPriorityCode());
        }
        return this.priority;
    }

    public String getPriorityCode() {
        if (this.priorityCode == null) {
            this.priorityCode = this.getBean().getString("priority");
            if (this.priorityCode == null) {
                this.priorityCode = Rank.LOW.toString();
            }
        }
        return this.priorityCode;
    }

    public boolean isMandatory() {
        return this.getBean().getBoolean("mandatoryAlert");
    }

    @Override
    public int compareTo(Alert object) {
        Priority priority2;
        Priority priority1;
        IMObject alertType2;
        int result = 0;
        IMObject alertType1 = this.getAlertType();
        if (!Objects.equals(alertType1, alertType2 = object.getAlertType()) && (result = (priority1 = this.getPriority()).compareTo(priority2 = object.getPriority())) == 0) {
            result = new Long(alertType1.getId()).compareTo(alertType2.getId());
        }
        return result;
    }

    public String getReason() {
        return this.alert != null ? this.alert.getReason() : null;
    }

    public boolean equals(Object obj) {
        boolean result = super.equals(obj);
        if (!result && obj instanceof Alert) {
            Alert other = (Alert)obj;
            result = this.alert != null ? Objects.equals(this.alert, other.getAlert()) : other.getAlert() == null && Objects.equals(this.alertType, other.getAlertType());
        }
        return result;
    }

    public int hashCode() {
        return this.alert != null ? this.alert.hashCode() : this.alertType.hashCode();
    }

    public static Alert create(Act act) {
        IMObjectBean bean = ServiceHelper.getArchetypeService().getBean((IMObject)act);
        Lookup alertType = null;
        if (bean.isA(new String[]{"act.customerAlert"})) {
            alertType = bean.getLookup("alertType");
        } else if (bean.isA(new String[]{"act.patientAlert"})) {
            alertType = bean.getTarget("alertType", IMObject.class);
        }
        return alertType != null ? new Alert((IMObject)alertType, act) : null;
    }

    private IMObjectBean getBean() {
        if (this.bean == null) {
            this.bean = ServiceHelper.getArchetypeService().getBean(this.alertType);
        }
        return this.bean;
    }

    public class Priority
    implements Comparable<Priority> {
        private final String code;
        private String displayName;
        private String name;

        public Priority(String code) {
            this.code = code;
        }

        public String getName() {
            if (this.name == null) {
                String value = ServiceHelper.getLookupService().getName(Alert.this.alertType, "priority");
                this.name = value != null ? value : this.code;
            }
            return this.name;
        }

        public Rank getRank() {
            return Rank.valueOf(this.code);
        }

        @Override
        public int compareTo(Priority o) {
            return this.getRank().compareTo(o.getRank());
        }

        public String getDisplayName() {
            if (this.displayName == null) {
                this.displayName = Alert.this.getBean().getDisplayName("priority");
            }
            return this.displayName;
        }
    }

    public static enum Rank {
        HIGH,
        MEDIUM,
        LOW;

    }
}

