/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.action;

import java.util.function.Consumer;
import org.apache.commons.lang.mutable.MutableBoolean;
import org.openvpms.web.component.action.Action;
import org.openvpms.web.component.action.ActionStatus;
import org.openvpms.web.component.action.DefaultActionStatusConsumer;

class RunnableAction
implements Action {
    private final Runnable action;
    private final boolean retryable;
    private final MutableBoolean interactive;

    public RunnableAction(Runnable action, MutableBoolean interactive, boolean retryable) {
        this.action = action;
        this.interactive = interactive;
        this.retryable = retryable;
    }

    @Override
    public void run() {
        this.run(new DefaultActionStatusConsumer(this.interactive.booleanValue()));
    }

    @Override
    public void run(Consumer<ActionStatus> listener) {
        try {
            this.action.run();
            listener.accept(ActionStatus.success());
        }
        catch (Throwable exception) {
            if (this.retryable) {
                listener.accept(ActionStatus.retry(exception));
            }
            listener.accept(ActionStatus.failed(exception));
        }
    }
}

