/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.action;

public class Behaviour {
    public static final int DEFAULT_RETRIES = 3;
    private final Instance instance;
    private final Missing missing;
    private final Changed changed;
    private final int retries;
    private final long delay;
    private static final int DEFAULT_DELAY = 1000;
    private static final Behaviour DEFAULT = ((BehaviourBuilder)((BehaviourBuilder)((BehaviourBuilder)Behaviour.newBehaviour().useOriginalObject()).retries(3)).delay(1000L)).build();

    private Behaviour(Instance instance, Missing missing, Changed changed, int retries, long delay) {
        this.instance = instance;
        this.missing = missing;
        this.changed = changed;
        this.delay = delay;
        this.retries = retries;
    }

    public boolean failIfMissing() {
        return this.missing == Missing.FAIL;
    }

    public boolean skipIfMissing() {
        return this.missing == Missing.SKIP;
    }

    public boolean failIfChanged() {
        return this.changed == Changed.FAIL;
    }

    public boolean skipIfChanged() {
        return this.changed == Changed.SKIP;
    }

    public boolean runIfChanged() {
        return this.changed == Changed.RUN;
    }

    public boolean useOriginalObject() {
        return this.instance == Instance.ORIGINAL;
    }

    public boolean useLatestInstance() {
        return this.instance == Instance.LATEST;
    }

    public boolean useLatestInstanceOnRetry() {
        return this.instance == Instance.LATEST_ON_RETRY;
    }

    public int getRetries() {
        return this.retries;
    }

    public long getDelay() {
        return this.delay;
    }

    public static BehaviourBuilder<?> newBehaviour() {
        return new BehaviourBuilder();
    }

    public static BehaviourBuilder<?> newBehaviour(Behaviour behaviour) {
        return new BehaviourBuilder(behaviour);
    }

    public static Behaviour getDefault() {
        return DEFAULT;
    }

    private static enum Changed {
        FAIL,
        SKIP,
        RUN;

    }

    private static enum Missing {
        FAIL,
        SKIP;

    }

    private static enum Instance {
        ORIGINAL,
        LATEST,
        LATEST_ON_RETRY;

    }

    public static class BehaviourBuilder<T extends BehaviourBuilder<T>> {
        private Instance instance = Instance.ORIGINAL;
        private Missing missing = Missing.FAIL;
        private Changed changed = Changed.FAIL;
        private int retries;
        private long delay;

        protected BehaviourBuilder() {
        }

        protected BehaviourBuilder(Behaviour behaviour) {
            this.instance = behaviour.instance;
            this.missing = behaviour.missing;
            this.changed = behaviour.changed;
            this.retries = behaviour.retries;
            this.delay = behaviour.delay;
        }

        public T useOriginalObject() {
            return this.useInstance(Instance.ORIGINAL);
        }

        public T useLatestInstance() {
            return this.useInstance(Instance.LATEST);
        }

        public T useLatestInstanceOnRetry() {
            return this.useInstance(Instance.LATEST_ON_RETRY);
        }

        public T failIfMissing() {
            return this.missing(Missing.FAIL);
        }

        public T skipIfMissing() {
            return this.skipIfMissing(true);
        }

        public T skipIfMissing(boolean skipIfMissing) {
            return this.missing(skipIfMissing ? Missing.SKIP : Missing.FAIL);
        }

        public T failIfChanged() {
            return this.changed(Changed.FAIL);
        }

        public T skipIfChanged() {
            return this.changed(Changed.SKIP);
        }

        public T runIfChanged() {
            return this.changed(Changed.RUN);
        }

        public T retries(int retries) {
            this.retries = retries;
            return this.getThis();
        }

        public T delay(long delay) {
            this.delay = delay;
            return this.getThis();
        }

        public Behaviour build() {
            return new Behaviour(this.instance, this.missing, this.changed, this.retries, this.delay);
        }

        private T useInstance(Instance instance) {
            this.instance = instance;
            if (instance == Instance.ORIGINAL) {
                this.failIfChanged();
                this.failIfMissing();
            } else {
                this.runIfChanged();
                this.failIfMissing();
            }
            return this.getThis();
        }

        private T missing(Missing missing) {
            this.missing = missing;
            return this.getThis();
        }

        private T getThis() {
            return (T)this;
        }

        private T changed(Changed changed) {
            this.changed = changed;
            return this.getThis();
        }
    }
}

