/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.retry;

import org.junit.Assert;
import org.junit.Test;
import org.openvpms.web.component.retry.Retryable;
import org.openvpms.web.component.retry.Retryer;

public class RetryerTestCase {
    @Test
    public void testRetryer() {
        Action action = new Action(9);
        Retryer retryer = new Retryer((Retryable)action);
        retryer.setDelay(0L);
        Assert.assertTrue((boolean)retryer.start());
        Assert.assertEquals((long)10L, (long)action.getCount());
    }

    @Test
    public void testSucceedTriggersThenAction() {
        FlagAction thenAction = new FlagAction();
        FlagAction elseAction = new FlagAction();
        Retryer retryer = new Retryer((Retryable)new Action(false), (Runnable)thenAction, (Runnable)elseAction);
        retryer.setDelay(0L);
        Assert.assertTrue((boolean)retryer.start());
        Assert.assertTrue((boolean)thenAction.hasRun());
        Assert.assertFalse((boolean)elseAction.hasRun());
    }

    @Test
    public void testFailTriggersElseAction() {
        FlagAction thenAction = new FlagAction();
        FlagAction elseAction = new FlagAction();
        Retryer retryer = new Retryer((Retryable)new Action(true), (Runnable)thenAction, (Runnable)elseAction);
        retryer.setDelay(0L);
        Assert.assertFalse((boolean)retryer.start());
        Assert.assertFalse((boolean)thenAction.hasRun());
        Assert.assertTrue((boolean)elseAction.hasRun());
    }

    @Test
    public void testEventualSucceedTriggersThenAction() {
        FlagAction thenAction = new FlagAction();
        FlagAction elseAction = new FlagAction();
        Retryer retryer = new Retryer((Retryable)new Action(9), (Runnable)thenAction, (Runnable)elseAction);
        retryer.setDelay(0L);
        Assert.assertTrue((boolean)retryer.start());
        Assert.assertTrue((boolean)thenAction.hasRun());
        Assert.assertFalse((boolean)elseAction.hasRun());
    }

    private static class FlagAction
    implements Runnable {
        private boolean run;

        private FlagAction() {
        }

        public boolean hasRun() {
            return this.run;
        }

        @Override
        public void run() {
            this.run = true;
        }
    }

    private static class Action
    implements Retryable {
        private boolean fail;
        private int attempts;
        int count = 0;

        public Action(boolean fail) {
            this.fail = fail;
        }

        public Action(int attempts) {
            this.fail = false;
            this.attempts = attempts;
        }

        public boolean run() {
            if (this.fail || ++this.count <= this.attempts) {
                throw new RuntimeException("RetryerTestCase - action set to fail");
            }
            return true;
        }

        public int getCount() {
            return this.count;
        }
    }
}

