/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.property;

import java.math.BigDecimal;
import org.junit.Assert;
import org.junit.Test;
import org.openvpms.archetype.test.TestHelper;
import org.openvpms.web.component.property.NumericPropertyTransformer;
import org.openvpms.web.component.property.Property;
import org.openvpms.web.component.property.PropertyException;
import org.openvpms.web.component.property.SimpleProperty;

public class NumericPropertyTransformerTestCase {
    @Test
    public void testIntegerApply() {
        SimpleProperty property = new SimpleProperty("int", Integer.class);
        NumericPropertyTransformer handler = new NumericPropertyTransformer((Property)property);
        Integer one = 1;
        try {
            handler.apply((Object)"abc");
            Assert.fail((String)"expected conversion from 'abc' to fail");
        }
        catch (PropertyException expected) {
            Assert.assertEquals((Object)property, (Object)expected.getProperty());
        }
        Integer int1 = (Integer)handler.apply((Object)"1");
        Assert.assertEquals((Object)one, (Object)int1);
        try {
            handler.apply((Object)"1.0");
            Assert.fail((String)"expected conversion from '1.0' to fail");
        }
        catch (PropertyException expected) {
            Assert.assertEquals((Object)property, (Object)expected.getProperty());
        }
        Assert.assertEquals((Object)one, (Object)handler.apply((Object)new Long(1L)));
        Assert.assertEquals((Object)one, (Object)handler.apply((Object)new BigDecimal(1.0)));
        Assert.assertEquals((Object)one, (Object)handler.apply((Object)new Double(1.5)));
    }

    @Test
    public void testDecimalApply() {
        BigDecimal one = new BigDecimal("1.0");
        BigDecimal half = new BigDecimal("0.5");
        SimpleProperty property = new SimpleProperty("dec", BigDecimal.class);
        NumericPropertyTransformer handler = new NumericPropertyTransformer((Property)property);
        try {
            handler.apply((Object)"abc");
        }
        catch (PropertyException expected) {
            Assert.assertEquals((Object)property, (Object)expected.getProperty());
        }
        BigDecimal dec1 = (BigDecimal)handler.apply((Object)"0.5");
        Assert.assertTrue((half.compareTo(dec1) == 0 ? 1 : 0) != 0);
        BigDecimal dec2 = (BigDecimal)handler.apply((Object)"1.0");
        Assert.assertTrue((one.compareTo(dec2) == 0 ? 1 : 0) != 0);
        BigDecimal dec3 = (BigDecimal)handler.apply((Object)new Long(1L));
        Assert.assertTrue((one.compareTo(dec3) == 0 ? 1 : 0) != 0);
        BigDecimal dec4 = (BigDecimal)handler.apply((Object)new BigDecimal(0.5));
        Assert.assertTrue((half.compareTo(dec4) == 0 ? 1 : 0) != 0);
        BigDecimal dec5 = (BigDecimal)handler.apply((Object)new Double(0.5));
        Assert.assertTrue((half.compareTo(dec5) == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testPositive() {
        SimpleProperty property = new SimpleProperty("int", Integer.class);
        NumericPropertyTransformer handler = new NumericPropertyTransformer((Property)property, true);
        try {
            handler.apply((Object)"-1");
        }
        catch (PropertyException expected) {
            Assert.assertEquals((Object)property, (Object)expected.getProperty());
            Assert.assertEquals((Object)"Int must be >= 0", (Object)expected.getMessage());
        }
        Integer int1 = (Integer)handler.apply((Object)"1");
        Assert.assertEquals((Object)new Integer(1), (Object)int1);
        Integer zero = (Integer)handler.apply((Object)0);
        Assert.assertEquals((Object)new Integer(0), (Object)zero);
    }

    @Test
    public void testOptionalNumeric() {
        SimpleProperty property = new SimpleProperty("concentration", BigDecimal.class);
        property.setRequired(false);
        NumericPropertyTransformer handler = new NumericPropertyTransformer((Property)property, true);
        Assert.assertNull((Object)handler.apply((Object)""));
        Assert.assertNull((Object)handler.apply(null));
        try {
            handler.apply((Object)"-1");
        }
        catch (PropertyException expected) {
            Assert.assertEquals((Object)property, (Object)expected.getProperty());
            Assert.assertEquals((Object)"Concentration must be >= 0", (Object)expected.getMessage());
        }
        TestHelper.checkEquals((BigDecimal)BigDecimal.ONE, (BigDecimal)((BigDecimal)handler.apply((Object)"1")));
    }
}

