/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.mail;

import org.junit.Assert;
import org.junit.Test;
import org.openvpms.web.component.mail.EmailAddress;

public class EmailAddressTestCase {
    @Test
    public void testParse() {
        EmailAddress address1 = EmailAddress.parse((String)"foo@bar.com");
        Assert.assertNull((Object)address1.getName());
        Assert.assertEquals((Object)"foo@bar.com", (Object)address1.getAddress());
        EmailAddress address2 = EmailAddress.parse((String)"<foo@bar.com>");
        Assert.assertNull((Object)address2.getName());
        Assert.assertEquals((Object)"foo@bar.com", (Object)address2.getAddress());
        EmailAddress address3 = EmailAddress.parse((String)"\"Foo Bar\" <foo@bar.com>");
        Assert.assertEquals((Object)"Foo Bar", (Object)address3.getName());
        Assert.assertEquals((Object)"foo@bar.com", (Object)address3.getAddress());
        EmailAddress address4 = EmailAddress.parse((String)"Foo Bar <foo@bar.com>");
        Assert.assertEquals((Object)"Foo Bar", (Object)address4.getName());
        Assert.assertEquals((Object)"foo@bar.com", (Object)address4.getAddress());
        EmailAddress address5 = EmailAddress.parse((String)"<foo@bar.com>");
        Assert.assertNull((Object)address5.getName());
        Assert.assertEquals((Object)"foo@bar.com", (Object)address5.getAddress());
        EmailAddress invalid1 = EmailAddress.parse(null);
        Assert.assertNull((Object)invalid1);
        EmailAddress invalid2 = EmailAddress.parse((String)"");
        Assert.assertNull((Object)invalid2);
        EmailAddress invalid3 = EmailAddress.parse((String)"@bar.com");
        Assert.assertNull((Object)invalid3);
        EmailAddress invalid4 = EmailAddress.parse((String)"foo@");
        Assert.assertNull((Object)invalid4);
    }
}

