/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.im.report;

import org.junit.Assert;
import org.junit.Test;
import org.openvpms.archetype.rules.doc.DocumentTemplate;
import org.openvpms.archetype.rules.doc.TemplateHelper;
import org.openvpms.archetype.test.ArchetypeServiceTest;
import org.openvpms.archetype.test.builder.doc.TestDocumentFactory;
import org.openvpms.archetype.test.builder.doc.TestDocumentTemplateBuilder;
import org.openvpms.archetype.test.builder.patient.TestPatientFactory;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.app.LocalContext;
import org.openvpms.web.component.im.report.ContextDocumentTemplateLocator;
import org.openvpms.web.component.im.report.DocumentActTemplateLocator;
import org.openvpms.web.component.im.report.DocumentTemplateLocator;
import org.openvpms.web.component.im.report.DocumentTemplateLocatorFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class DocumentTemplateLocatorFactoryTestCase
extends ArchetypeServiceTest {
    @Autowired
    private TestDocumentFactory documentFactory;
    @Autowired
    private TestPatientFactory patientFactory;

    @Test
    public void testContextTemplateLocator() {
        DocumentTemplateLocatorFactory factory = new DocumentTemplateLocatorFactory((ArchetypeService)this.getArchetypeService());
        TemplateHelper helper = new TemplateHelper((ArchetypeService)this.getArchetypeService());
        Entity entity = helper.getTemplateForType("act.customerAccountChargesInvoice");
        if (entity == null) {
            entity = (Entity)((TestDocumentTemplateBuilder)this.documentFactory.newTemplate().type("act.customerAccountChargesInvoice").blankDocument()).build();
        }
        IMObject invoice = this.create("act.customerAccountChargesInvoice");
        DocumentTemplateLocator locator = factory.getDocumentTemplateLocator(invoice, (Context)new LocalContext());
        Assert.assertTrue((boolean)(locator instanceof ContextDocumentTemplateLocator));
        DocumentTemplate template = factory.getTemplate(invoice, (Context)new LocalContext());
        Assert.assertNotNull((Object)template);
        Assert.assertEquals((Object)entity, (Object)template.getEntity());
    }

    @Test
    public void testDocumentActTemplateLocator() {
        DocumentTemplateLocatorFactory factory = new DocumentTemplateLocatorFactory((ArchetypeService)this.getArchetypeService());
        Entity entity = this.documentFactory.createTemplate("act.patientDocumentForm");
        IMObject object = this.patientFactory.newForm().template(entity).build(false);
        DocumentTemplateLocator locator = factory.getDocumentTemplateLocator(object, (Context)new LocalContext());
        Assert.assertTrue((boolean)(locator instanceof DocumentActTemplateLocator));
        DocumentTemplate template = factory.getTemplate(object, (Context)new LocalContext());
        Assert.assertNotNull((Object)template);
        Assert.assertEquals((Object)entity, (Object)template.getEntity());
    }

    @Test
    public void testNoTemplate() {
        DocumentTemplateLocatorFactory factory = new DocumentTemplateLocatorFactory((ArchetypeService)this.getArchetypeService());
        IMObject object = this.create("lookup.species");
        Assert.assertNull((Object)factory.getTemplate(object, (Context)new LocalContext()));
    }
}

