/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.im.relationship;

import org.openvpms.archetype.test.TestHelper;
import org.openvpms.component.business.service.archetype.helper.IMObjects;
import org.openvpms.component.model.lookup.Lookup;
import org.openvpms.component.model.lookup.LookupRelationship;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.web.component.im.edit.AbstractCollectionPropertyEditorTest;
import org.openvpms.web.component.im.edit.CollectionPropertyEditor;
import org.openvpms.web.component.im.relationship.LookupRelationshipCollectionPropertyEditor;
import org.openvpms.web.component.property.CollectionProperty;

public class LookupRelationshipCollectionPropertyEditorTestCase
extends AbstractCollectionPropertyEditorTest {
    private Lookup state;

    @Override
    public void setUp() {
        super.setUp();
        this.state = TestHelper.getLookup((String)"lookup.state", (String)"VIC");
        if (!this.state.getLookupRelationships().isEmpty()) {
            this.state.getSourceLookupRelationships().clear();
            this.save((IMObject)this.state);
        }
    }

    @Override
    protected IMObject createParent() {
        return this.state;
    }

    @Override
    protected String getCollectionNode() {
        return "source";
    }

    @Override
    protected CollectionPropertyEditor createEditor(CollectionProperty property, IMObject parent, IMObjects objects) {
        return new LookupRelationshipCollectionPropertyEditor(property, (Lookup)parent);
    }

    @Override
    protected IMObject createObject(IMObject parent) {
        LookupRelationship result = (LookupRelationship)TestHelper.create((String)"lookupRelationship.stateSuburb");
        result.setSource(parent.getObjectReference());
        Lookup target = this.createLookup();
        result.setTarget(target.getObjectReference());
        return result;
    }

    @Override
    protected void makeValid(IMObject object, boolean valid) {
        LookupRelationship relationship = (LookupRelationship)object;
        relationship.setTarget(valid ? this.createLookup().getObjectReference() : null);
    }

    @Override
    protected void modify(IMObject object) {
        LookupRelationship relationship = (LookupRelationship)object;
        relationship.setTarget(this.createLookup().getObjectReference());
    }

    private Lookup createLookup() {
        String code = "ASUBURB" + System.currentTimeMillis() + System.nanoTime();
        return TestHelper.getLookup((String)"lookup.suburb", (String)code);
    }
}

