/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.im.query;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.junit.Assert;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.web.component.im.query.Query;
import org.openvpms.web.component.im.query.ResultSet;
import org.openvpms.web.component.im.query.ResultSetIterator;

public class QueryTestHelper {
    public static <T extends IMObject> void checkEmpty(Query<T> query) {
        ResultSet set = query.query();
        if (set != null) {
            Assert.assertEquals((long)0L, (long)set.getResults());
        }
    }

    public static <T extends IMObject> void checkSelects(boolean selects, Query<T> query, T value) {
        Assert.assertEquals((Object)selects, (Object)query.selects(value));
        Assert.assertEquals((Object)selects, (Object)query.selects(value.getObjectReference()));
    }

    public static <T extends IMObject> List<Reference> checkExists(T object, Query<T> query, boolean exists) {
        List<Reference> matches = QueryTestHelper.getObjectRefs(query);
        QueryTestHelper.checkExists(object, query, matches, exists);
        return matches;
    }

    @SafeVarargs
    public static <T extends IMObject> void checkExists(Query<T> query, T ... objects) {
        QueryTestHelper.checkExists(query, Arrays.asList(objects), true);
    }

    public static <T extends IMObject> void checkExists(Query<T> query, List<T> objects) {
        QueryTestHelper.checkExists(query, objects, true);
    }

    @SafeVarargs
    public static <T extends IMObject> void checkNotExists(Query<T> query, T ... objects) {
        QueryTestHelper.checkExists(query, Arrays.asList(objects), false);
    }

    public static <T extends IMObject> void checkExists(T object, Query<T> query, List<Reference> matches, boolean exists) {
        int cardinality = exists ? 1 : 0;
        Assert.assertEquals((long)cardinality, (long)CollectionUtils.cardinality((Object)object.getObjectReference(), matches));
        Assert.assertEquals((Object)exists, (Object)query.selects(object));
        Assert.assertEquals((Object)exists, (Object)query.selects(object.getObjectReference()));
    }

    public static <T extends IMObject> List<Reference> getObjectRefs(Query<T> query) {
        ArrayList<Reference> result = new ArrayList<Reference>();
        for (IMObject object : query) {
            result.add(object.getObjectReference());
        }
        return result;
    }

    public static <T extends IMObject> List<Reference> getObjectRefs(ResultSet<T> set) {
        ArrayList<Reference> result = new ArrayList<Reference>();
        ResultSetIterator iterator = new ResultSetIterator(set);
        while (iterator.hasNext()) {
            result.add(((IMObject)iterator.next()).getObjectReference());
        }
        return result;
    }

    private static <T extends IMObject> void checkExists(Query<T> query, List<T> objects, boolean exists) {
        List<Reference> matches = QueryTestHelper.getObjectRefs(query);
        for (IMObject object : objects) {
            QueryTestHelper.checkExists(object, query, matches, exists);
        }
    }
}

