/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.im.product;

import org.apache.commons.lang3.ArrayUtils;
import org.junit.Assert;
import org.junit.Test;
import org.openvpms.archetype.test.builder.laboratory.TestLaboratoryFactory;
import org.openvpms.archetype.test.builder.laboratory.TestLaboratoryTestBuilder;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.app.LocalContext;
import org.openvpms.web.component.im.product.TestQuery;
import org.openvpms.web.component.im.query.AbstractEntityQueryTest;
import org.openvpms.web.component.im.query.Query;
import org.openvpms.web.component.im.query.QueryFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class TestQueryTestCase
extends AbstractEntityQueryTest<Entity> {
    @Autowired
    private TestLaboratoryFactory factory;

    @Test
    public void testQueryFactory() {
        this.checkCreate("entity.laboratoryTest*", "entity.laboratoryTest", "entity.laboratoryTestHL7");
        this.checkCreate("entity.laboratoryTest", "entity.laboratoryTest");
        this.checkCreate("entity.laboratoryTestHL7", "entity.laboratoryTestHL7");
    }

    @Test
    public void testSearchAll() {
        TestQuery query = (TestQuery)this.createQuery();
        Assert.assertTrue((boolean)query.isSearchAll());
        String test1Name = "1" + this.getUniqueValue();
        String test1Code = "2" + this.getUniqueValue();
        String test2Name = "3" + this.getUniqueValue();
        String test2Code = "4" + this.getUniqueValue();
        Entity test1 = this.createTest(test1Name, test1Code, true);
        Entity test2 = this.createTest(test2Name, test2Code, true);
        Assert.assertTrue((boolean)query.isIdentitySearch());
        query.setIdentitySearch(false);
        query.setValue(test1Name);
        this.checkExists(test1, query, true);
        this.checkExists(test2, query, false);
        query.setValue(test1Code);
        this.checkExists(test1, query, false);
        this.checkExists(test2, query, false);
        query.setIdentitySearch(true);
        this.checkExists(test1, query, true);
        this.checkExists(test2, query, false);
        query.setValue(test2Name);
        this.checkExists(test1, query, false);
        this.checkExists(test2, query, true);
        query.setValue(test2Code);
        this.checkExists(test1, query, false);
        this.checkExists(test2, query, true);
        query.setValue(Long.toString(test1.getId()));
        this.checkExists(test1, query, true);
        this.checkExists(test2, query, false);
    }

    @Override
    protected Query<Entity> createQuery() {
        return new TestQuery((Context)new LocalContext());
    }

    @Override
    protected Entity createObject(String value, boolean save) {
        return this.createTest(value, null, save);
    }

    @Override
    protected String getUniqueValue() {
        return this.getUniqueValue("ZTest");
    }

    private void checkCreate(String archetype, String ... expected) {
        Query query = QueryFactory.create((String)archetype, (Context)new LocalContext(), Entity.class);
        Assert.assertTrue((boolean)(query instanceof TestQuery));
        Object[] archetypes = query.getShortNames();
        Assert.assertEquals((long)expected.length, (long)archetypes.length);
        for (String expectedArchetype : expected) {
            Assert.assertTrue((boolean)ArrayUtils.contains((Object[])archetypes, (Object)expectedArchetype));
        }
    }

    private Entity createTest(String name, String code, boolean save) {
        TestLaboratoryTestBuilder builder = (TestLaboratoryTestBuilder)((TestLaboratoryTestBuilder)this.factory.newTest().name(name)).investigationType(this.factory.createInvestigationType());
        if (code != null) {
            builder.code("entityIdentity.laboratoryTest", code);
        }
        return (Entity)builder.build(save);
    }
}

