/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.im.product;

import java.math.BigDecimal;
import java.util.Date;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.openvpms.archetype.rules.product.ProductPriceTestHelper;
import org.openvpms.archetype.rules.util.DateRules;
import org.openvpms.archetype.test.TestHelper;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.lookup.Lookup;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.model.product.Product;
import org.openvpms.component.model.product.ProductPrice;
import org.openvpms.component.model.user.User;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.app.LocalContext;
import org.openvpms.web.component.im.layout.DefaultLayoutContext;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.im.product.ProductPriceEditor;
import org.openvpms.web.echo.help.HelpContext;
import org.openvpms.web.test.AbstractAppTest;

public class ProductPriceEditorTestCase
extends AbstractAppTest {
    private Context context;
    private Product product;

    @Override
    @Before
    public void setUp() {
        Party practice = TestHelper.getPractice();
        practice.addClassification(TestHelper.createTaxType((BigDecimal)BigDecimal.TEN));
        this.save((IMObject)practice);
        this.context = new LocalContext();
        this.context.setPractice(practice);
        this.product = TestHelper.createProduct();
        super.setUp();
    }

    @Test
    public void testUpdates() {
        ProductPrice unitPrice = (ProductPrice)this.create("productPrice.unitPrice", ProductPrice.class);
        this.checkUpdates(unitPrice);
        ProductPrice fixedPrice = (ProductPrice)this.create("productPrice.fixedPrice", ProductPrice.class);
        this.checkUpdates(fixedPrice);
    }

    @Test
    public void testIsReadOnly() {
        User user = TestHelper.createUser((boolean)false);
        User admin = TestHelper.createAdministrator((boolean)false);
        ProductPrice price1 = ProductPriceTestHelper.createFixedPrice((Date)DateRules.getYesterday(), null, (boolean)false);
        ProductPrice price2 = ProductPriceTestHelper.createFixedPrice((Date)DateRules.getToday(), null, (boolean)false);
        ProductPrice price3 = ProductPriceTestHelper.createFixedPrice((Date)DateRules.getTomorrow(), null, (boolean)false);
        ProductPrice price4 = ProductPriceTestHelper.createFixedPrice((Date)null, null, (boolean)false);
        Product product = TestHelper.createProduct();
        product.addProductPrice(price1);
        product.addProductPrice(price2);
        product.addProductPrice(price3);
        product.addProductPrice(price4);
        this.checkReadOnly(price1, product, user, false);
        this.checkReadOnly(price2, product, user, false);
        this.checkReadOnly(price3, product, user, false);
        this.checkReadOnly(price4, product, user, false);
        this.checkReadOnly(price1, product, admin, false);
        this.checkReadOnly(price2, product, admin, false);
        this.checkReadOnly(price3, product, admin, false);
        this.checkReadOnly(price4, product, admin, false);
        this.save((IMObject)product);
        this.checkReadOnly(price1, product, user, true);
        this.checkReadOnly(price2, product, user, false);
        this.checkReadOnly(price3, product, user, false);
        this.checkReadOnly(price4, product, user, true);
        this.checkReadOnly(price1, product, admin, false);
        this.checkReadOnly(price2, product, admin, false);
        this.checkReadOnly(price3, product, admin, false);
        this.checkReadOnly(price4, product, admin, false);
    }

    @Test
    public void testPriceRounding() {
        DefaultLayoutContext layout = new DefaultLayoutContext(this.context, new HelpContext("foo", null));
        Lookup currency = TestHelper.getCurrency((String)"AUD");
        IMObjectBean bean = this.getBean((IMObject)currency);
        bean.setValue("minPrice", (Object)"0.00");
        bean.save();
        ProductPrice price1 = (ProductPrice)this.create("productPrice.unitPrice", ProductPrice.class);
        ProductPriceEditor editor1 = new ProductPriceEditor(price1, this.product, (LayoutContext)layout);
        editor1.setCost(BigDecimal.valueOf(1.63));
        this.checkPrice(editor1, "1.63", "100", "3.26", "3.59", "50");
        editor1.setMarkup(BigDecimal.valueOf(50L));
        this.checkPrice(editor1, "1.63", "50", "2.445", "2.69", "33.30");
        editor1.setMarkup(BigDecimal.valueOf(75L));
        this.checkPrice(editor1, "1.63", "75", "2.853", "3.14", "42.90");
        bean.setValue("minPrice", (Object)"0.20");
        bean.save();
        ProductPrice price2 = (ProductPrice)this.create("productPrice.unitPrice", ProductPrice.class);
        ProductPriceEditor editor2 = new ProductPriceEditor(price2, this.product, (LayoutContext)layout);
        editor2.setCost(BigDecimal.valueOf(1.63));
        this.checkPrice(editor2, "1.63", "100.00", "3.26", "3.60", "50.00");
        editor2.setMarkup(BigDecimal.valueOf(50L));
        this.checkPrice(editor2, "1.63", "50.00", "2.445", "2.60", "33.30");
        editor2.setMarkup(BigDecimal.valueOf(75L));
        this.checkPrice(editor2, "1.63", "75", "2.853", "3.20", "42.90");
    }

    protected void checkUpdates(ProductPrice price) {
        DefaultLayoutContext layout = new DefaultLayoutContext(this.context, new HelpContext("foo", null));
        ProductPriceEditor editor = new ProductPriceEditor(price, this.product, (LayoutContext)layout);
        this.checkPrice(editor, "0.00", "100", "0.00", "0.00", "100");
        editor.setCost(BigDecimal.ONE);
        this.checkPrice(editor, "1.00", "100", "2.00", "2.20", "50");
        editor.setMarkup(BigDecimal.valueOf(50L));
        this.checkPrice(editor, "1.00", "50", "1.50", "1.65", "33.3");
        editor.setPrice(BigDecimal.valueOf(2L));
        this.checkPrice(editor, "1.00", "100", "2.00", "2.20", "50");
    }

    private void checkReadOnly(ProductPrice price, Product product, User user, boolean expected) {
        this.context.setUser(user);
        DefaultLayoutContext layout = new DefaultLayoutContext(this.context, new HelpContext("foo", null));
        ProductPriceEditor editor = new ProductPriceEditor(price, product, (LayoutContext)layout);
        Assert.assertEquals((Object)expected, (Object)editor.isReadOnly());
    }

    private void checkPrice(ProductPriceEditor editor, String cost, String markup, String price, String taxIncPrice, String maxDiscount) {
        this.checkEquals(new BigDecimal(cost), editor.getCost());
        this.checkEquals(new BigDecimal(markup), editor.getMarkup());
        this.checkEquals(new BigDecimal(price), editor.getPrice());
        this.checkEquals(new BigDecimal(taxIncPrice), editor.getTaxInclusivePrice());
        this.checkEquals(new BigDecimal(maxDiscount), editor.getMaxDiscount());
    }
}

