/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.im.edit.act;

import java.math.BigDecimal;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.openvpms.archetype.test.builder.customer.TestCustomerFactory;
import org.openvpms.archetype.test.builder.customer.account.TestCustomerAccountFactory;
import org.openvpms.archetype.test.builder.customer.account.TestEstimateBuilder;
import org.openvpms.archetype.test.builder.patient.TestPatientFactory;
import org.openvpms.archetype.test.builder.product.TestProductFactory;
import org.openvpms.component.business.service.archetype.helper.IMObjects;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.act.ActRelationship;
import org.openvpms.component.model.archetype.ArchetypeRange;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.product.Product;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.component.system.common.cache.MapIMObjectCache;
import org.openvpms.web.component.im.edit.AbstractCollectionPropertyEditorTest;
import org.openvpms.web.component.im.edit.CollectionPropertyEditor;
import org.openvpms.web.component.im.edit.SaveHelper;
import org.openvpms.web.component.im.edit.act.ActRelationshipCollectionPropertyEditor;
import org.openvpms.web.component.property.CollectionProperty;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;

public class ActRelationshipCollectionPropertyEditorTestCase
extends AbstractCollectionPropertyEditorTest {
    @Autowired
    private TestCustomerAccountFactory accountFactory;
    @Autowired
    private TestCustomerFactory customerFactory;
    @Autowired
    private TestPatientFactory patientFactory;
    @Autowired
    private TestProductFactory productFactory;
    private Product product;
    private IMObjects objects;

    @Override
    @Before
    public void setUp() {
        super.setUp();
        this.product = this.productFactory.createMedication();
        this.objects = new MapIMObjectCache((ArchetypeService)this.getArchetypeService());
    }

    @Test
    public void testGetArchetypeRange() {
        IMObject parent = this.createParent();
        CollectionProperty property = this.getCollectionProperty(parent);
        ActRelationshipCollectionPropertyEditor editor = this.createEditor(property, parent, this.objects);
        String[] range = editor.getArchetypeRange();
        Assert.assertEquals((long)1L, (long)range.length);
        Assert.assertEquals((Object)"act.customerEstimationItem", (Object)range[0]);
    }

    @Test
    public void testGetArchetypes() {
        IMObject parent = this.createParent();
        CollectionProperty property = this.getCollectionProperty(parent);
        ActRelationshipCollectionPropertyEditor editor = this.createEditor(property, parent, this.objects);
        ArchetypeRange range = editor.getArchetypes();
        List archetypes = range.getArchetypes();
        Assert.assertEquals((long)1L, (long)archetypes.size());
        Assert.assertEquals((Object)"act.customerEstimationItem", archetypes.get(0));
        Assert.assertNull((Object)range.getDefaultArchetype());
    }

    @Test
    public void testSaveTwice() {
        IMObject parent = this.createParent();
        CollectionProperty property = this.getCollectionProperty(parent);
        ActRelationshipCollectionPropertyEditor editor = this.createEditor(property, parent, this.objects);
        IMObject element = this.createObject(parent);
        editor.add(element);
        Assert.assertEquals((long)1L, (long)editor.getObjects().size());
        Assert.assertSame((Object)element, editor.getObjects().get(0));
        this.execute((TransactionCallback<Object>)((TransactionCallback)arg_0 -> ActRelationshipCollectionPropertyEditorTestCase.lambda$testSaveTwice$0(parent, (CollectionPropertyEditor)editor, arg_0)));
        Assert.assertEquals((long)0L, (long)parent.getVersion());
        Assert.assertEquals((long)0L, (long)element.getVersion());
        Assert.assertTrue((boolean)SaveHelper.save((IMObject)parent));
        editor.add(element);
        this.modify(element);
        editor.save();
        Assert.assertEquals((long)0L, (long)parent.getVersion());
        Assert.assertEquals((long)1L, (long)element.getVersion());
        IMObject savedParent = this.get(parent);
        Assert.assertNotNull((Object)savedParent);
        ActRelationshipCollectionPropertyEditor saved = this.createEditor(this.getCollectionProperty(savedParent), savedParent, this.objects);
        Assert.assertEquals((long)1L, (long)saved.getObjects().size());
        Assert.assertTrue((boolean)saved.getObjects().contains(element));
    }

    @Test
    public void testSequence() {
        IMObject parent = this.createParent();
        CollectionProperty property = this.getCollectionProperty(parent);
        ActRelationshipCollectionPropertyEditor editor1 = this.createEditor(property, parent, this.objects);
        IMObject object1 = this.createObject(parent);
        IMObject object2 = this.createObject(parent);
        IMObject object3 = this.createObject(parent);
        IMObject object4 = this.createObject(parent);
        IMObject object5 = this.createObject(parent);
        editor1.add(object1);
        editor1.add(object2);
        editor1.add(object3);
        Assert.assertEquals((long)3L, (long)editor1.getObjects().size());
        Assert.assertEquals((long)0L, (long)((ActRelationship)editor1.getRelationship(object1)).getSequence());
        Assert.assertEquals((long)1L, (long)((ActRelationship)editor1.getRelationship(object2)).getSequence());
        Assert.assertEquals((long)2L, (long)((ActRelationship)editor1.getRelationship(object3)).getSequence());
        editor1.remove(object2);
        editor1.add(object4);
        Assert.assertEquals((long)3L, (long)editor1.getObjects().size());
        Assert.assertEquals((long)0L, (long)((ActRelationship)editor1.getRelationship(object1)).getSequence());
        Assert.assertNull((Object)editor1.getRelationship(object2));
        Assert.assertEquals((long)2L, (long)((ActRelationship)editor1.getRelationship(object3)).getSequence());
        Assert.assertEquals((long)3L, (long)((ActRelationship)editor1.getRelationship(object4)).getSequence());
        editor1.remove(object4);
        editor1.add(object5);
        Assert.assertEquals((long)3L, (long)editor1.getObjects().size());
        Assert.assertEquals((long)0L, (long)((ActRelationship)editor1.getRelationship(object1)).getSequence());
        Assert.assertNull((Object)editor1.getRelationship(object2));
        Assert.assertEquals((long)2L, (long)((ActRelationship)editor1.getRelationship(object3)).getSequence());
        Assert.assertNull((Object)editor1.getRelationship(object4));
        Assert.assertEquals((long)3L, (long)((ActRelationship)editor1.getRelationship(object5)).getSequence());
        this.execute((TransactionCallback<Object>)((TransactionCallback)transactionStatus -> {
            Assert.assertTrue((boolean)SaveHelper.save((IMObject)parent));
            editor1.save();
            return null;
        }));
        ActRelationshipCollectionPropertyEditor editor2 = this.createEditor(property, parent, this.objects);
        Assert.assertEquals((long)3L, (long)editor2.getObjects().size());
        Assert.assertEquals((long)0L, (long)((ActRelationship)editor2.getRelationship(object1)).getSequence());
        Assert.assertEquals((long)2L, (long)((ActRelationship)editor2.getRelationship(object3)).getSequence());
        Assert.assertEquals((long)3L, (long)((ActRelationship)editor2.getRelationship(object5)).getSequence());
        IMObject object6 = this.createObject(parent);
        editor2.add(object6);
        Assert.assertEquals((long)4L, (long)editor2.getObjects().size());
        Assert.assertEquals((long)0L, (long)((ActRelationship)editor2.getRelationship(object1)).getSequence());
        Assert.assertEquals((long)2L, (long)((ActRelationship)editor2.getRelationship(object3)).getSequence());
        Assert.assertEquals((long)3L, (long)((ActRelationship)editor2.getRelationship(object5)).getSequence());
        Assert.assertEquals((long)4L, (long)((ActRelationship)editor2.getRelationship(object6)).getSequence());
    }

    @Override
    protected IMObject createParent() {
        return ((TestEstimateBuilder)this.accountFactory.newEstimate().customer(this.customerFactory.createCustomer()).status("IN_PROGRESS")).build(false);
    }

    @Override
    protected String getCollectionNode() {
        return "items";
    }

    protected ActRelationshipCollectionPropertyEditor createEditor(CollectionProperty property, IMObject parent, IMObjects objects) {
        return new ActRelationshipCollectionPropertyEditor(property, (Act)parent, objects);
    }

    @Override
    protected IMObject createObject(IMObject parent) {
        return this.accountFactory.newEstimateItem().patient(this.patientFactory.createPatient()).product(this.product).build(false);
    }

    @Override
    protected void makeValid(IMObject object, boolean valid) {
        IMObjectBean bean = this.getBean(object);
        if (!valid) {
            bean.setTarget("product", (IMObject)((Product)null));
        } else {
            bean.setTarget("product", (IMObject)this.product);
        }
    }

    @Override
    protected void modify(IMObject object) {
        IMObjectBean bean = this.getBean(object);
        bean.setValue("highTotal", (Object)bean.getBigDecimal("highTotal").add(BigDecimal.ONE));
    }

    private static /* synthetic */ Object lambda$testSaveTwice$0(IMObject parent, CollectionPropertyEditor editor, TransactionStatus transactionStatus) {
        Assert.assertTrue((boolean)SaveHelper.save((IMObject)parent));
        editor.save();
        return null;
    }
}

