/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.im.doc;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.openvpms.archetype.rules.doc.DocumentTemplate;
import org.openvpms.archetype.rules.patient.PatientRules;
import org.openvpms.archetype.test.ArchetypeServiceTest;
import org.openvpms.archetype.test.TestHelper;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.lookup.Lookup;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.web.component.im.doc.FileNameFormatter;
import org.springframework.beans.factory.annotation.Autowired;

public class FileNameFormatterTestCase
extends ArchetypeServiceTest {
    @Autowired
    private PatientRules patientRules;
    private FileNameFormatter formatter;

    @Before
    public void setUp() {
        this.formatter = new FileNameFormatter((ArchetypeService)this.getArchetypeService(), this.getLookupService(), this.patientRules);
    }

    @Test
    public void testSimpleFormat() {
        DocumentTemplate template = this.createTemplate("$file");
        Assert.assertEquals((Object)"foo", (Object)this.formatter.format("foo.txt", null, template));
    }

    @Test
    public void testCustomerFormat() {
        DocumentTemplate template = this.createTemplate("concat($file, ' - ', party:getPartyFullName($customer))");
        Party customer = TestHelper.createCustomer((String)"Foo", (String)"Bar", (boolean)true);
        IMObjectBean bean = this.getBean((IMObject)customer);
        bean.setValue("title", null);
        bean.save();
        Act act = (Act)this.create("act.customerDocumentLetter", Act.class);
        IMObjectBean actBean = this.getBean((IMObject)act);
        actBean.setTarget("customer", (IMObject)customer);
        Assert.assertEquals((Object)"Statement - Foo Bar", (Object)this.formatter.format("Statement.pdf", (IMObject)act, template));
    }

    @Test
    public void testPatientFormat() {
        DocumentTemplate template = this.createTemplate("concat($file, ' - ', $patient.name)");
        Party patient = TestHelper.createPatient();
        patient.setName("Fido");
        this.save((IMObject)patient);
        Act act = (Act)this.create("act.patientDocumentLetter", Act.class);
        IMObjectBean bean = this.getBean((IMObject)act);
        bean.setTarget("patient", (IMObject)patient);
        Assert.assertEquals((Object)"Referral - Fido", (Object)this.formatter.format("Referral.pdf", (IMObject)act, template));
    }

    @Test
    public void testCustomerPatientFormat() {
        DocumentTemplate template = this.createTemplate("concat($file, ' - ', $patient.name, ' ', $customer.lastName)");
        Party customer = TestHelper.createCustomer((String)"Foo", (String)"Bar", (boolean)true);
        Party patient = TestHelper.createPatient((Party)customer);
        patient.setName("Fido");
        this.save((IMObject)patient);
        Act act = (Act)this.create("act.patientDocumentLetter", Act.class);
        IMObjectBean bean = this.getBean((IMObject)act);
        bean.setTarget("patient", (IMObject)patient);
        Assert.assertEquals((Object)"Referral - Fido Bar", (Object)this.formatter.format("Referral.pdf", (IMObject)act, template));
    }

    @Test
    public void testSupplierFormat() {
        DocumentTemplate template = this.createTemplate("concat($supplier.name, ' ', $file)");
        Party supplier = (Party)this.create("party.supplierVeterinaryPractice", Party.class);
        supplier.setName("Eastside");
        this.save((IMObject)supplier);
        Act act = (Act)this.create("act.supplierDocumentLetter", Act.class);
        IMObjectBean bean = this.getBean((IMObject)act);
        bean.setTarget("supplier", (IMObject)supplier);
        Assert.assertEquals((Object)"Eastside Referral", (Object)this.formatter.format("Referral.pdf", (IMObject)act, template));
    }

    @Test
    public void testIllegalCharacters() {
        DocumentTemplate template = this.createTemplate("concat($file, ' - ', $patient.name)");
        Party patient = TestHelper.createPatient();
        patient.setName("\\/:*?<>|");
        this.save((IMObject)patient);
        Act act = (Act)this.create("act.patientDocumentLetter", Act.class);
        IMObjectBean bean = this.getBean((IMObject)act);
        bean.setTarget("patient", (IMObject)patient);
        Assert.assertEquals((Object)"Referral - ________", (Object)this.formatter.format("Referral.pdf", (IMObject)act, template));
    }

    @Test
    public void testLookupFormat() {
        Lookup lookup = this.createFormat("concat($file, ' - ', $patient.name)");
        Party patient = TestHelper.createPatient();
        patient.setName("Fido");
        this.save((IMObject)patient);
        Act act = (Act)this.create("act.patientDocumentLetter", Act.class);
        IMObjectBean bean = this.getBean((IMObject)act);
        bean.setTarget("patient", (IMObject)patient);
        Assert.assertEquals((Object)"Referral - Fido", (Object)this.formatter.format("Referral.pdf", (IMObject)act, lookup));
    }

    private DocumentTemplate createTemplate(String expression) {
        Entity entity = (Entity)this.create("entity.documentTemplate", Entity.class);
        Lookup lookup = this.createFormat(expression);
        DocumentTemplate template = new DocumentTemplate(entity, (ArchetypeService)this.getArchetypeService());
        Assert.assertNull((Object)template.getFileNameExpression());
        entity.addClassification(lookup);
        return new DocumentTemplate(entity, (ArchetypeService)this.getArchetypeService());
    }

    private Lookup createFormat(String expression) {
        Lookup lookup = (Lookup)this.create("lookup.fileNameFormat", Lookup.class);
        IMObjectBean bean = this.getBean((IMObject)lookup);
        bean.setValue("expression", (Object)expression);
        return lookup;
    }
}

