/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.im.doc;

import java.util.Objects;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.openvpms.archetype.test.builder.customer.TestCustomerFactory;
import org.openvpms.archetype.test.builder.customer.document.TestCustomerLetterBuilder;
import org.openvpms.archetype.test.builder.doc.TestDocumentFactory;
import org.openvpms.archetype.test.builder.doc.TestDocumentTemplateBuilder;
import org.openvpms.component.model.act.DocumentAct;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.Reference;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.app.LocalContext;
import org.openvpms.web.component.im.doc.DocumentActEditDialog;
import org.openvpms.web.component.im.doc.DocumentActEditor;
import org.openvpms.web.component.im.edit.IMObjectEditor;
import org.openvpms.web.component.im.edit.SaveHelper;
import org.openvpms.web.component.im.layout.DefaultLayoutContext;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.echo.dialog.ConfirmationDialog;
import org.openvpms.web.echo.dialog.PopupDialog;
import org.openvpms.web.echo.help.HelpContext;
import org.openvpms.web.test.AbstractAppTest;
import org.openvpms.web.test.EchoTestHelper;
import org.springframework.beans.factory.annotation.Autowired;

public class DocumentActEditDialogTestCase
extends AbstractAppTest {
    @Autowired
    private TestCustomerFactory customerFactory;
    @Autowired
    private TestDocumentFactory documentFactory;
    private DocumentAct act;
    private Context context;

    @Override
    @Before
    public void setUp() {
        super.setUp();
        this.act = (DocumentAct)((TestCustomerLetterBuilder)this.customerFactory.newLetter().customer(this.customerFactory.createCustomer())).build(false);
        this.context = new LocalContext();
    }

    @Test
    public void testApply() {
        DocumentActEditor editor = this.createEditor();
        Assert.assertEquals((Object)DocumentActEditor.DocumentStatus.UP_TO_DATE, (Object)editor.getDocumentStatus());
        DocumentActEditDialog dialog = this.createDialog(editor);
        dialog.show();
        editor.setTemplate(this.createDocumentTemplate());
        Assert.assertEquals((Object)DocumentActEditor.DocumentStatus.NEEDS_UPDATE, (Object)editor.getDocumentStatus());
        editor.documentAttributeModified(false);
        Assert.assertEquals((Object)DocumentActEditor.DocumentStatus.NEEDS_UPDATE, (Object)editor.getDocumentStatus());
        EchoTestHelper.fireDialogButton((PopupDialog)dialog, "apply");
        this.processQueuedTasks(10, () -> this.act.getDocument() != null);
        Assert.assertEquals((Object)DocumentActEditor.DocumentStatus.UP_TO_DATE, (Object)editor.getDocumentStatus());
        Reference docRef1 = this.act.getDocument();
        Assert.assertNotNull((Object)docRef1);
        Assert.assertNotNull((Object)this.get(docRef1));
        editor.getProperty("description").setValue((Object)"a description");
        Assert.assertEquals((Object)DocumentActEditor.DocumentStatus.UP_TO_DATE, (Object)editor.getDocumentStatus());
        EchoTestHelper.fireDialogButton((PopupDialog)dialog, "apply");
        this.processQueuedTasks();
        Assert.assertEquals((Object)docRef1, (Object)this.act.getDocument());
        editor.documentAttributeModified(false);
        Assert.assertEquals((Object)DocumentActEditor.DocumentStatus.PROMPT, (Object)editor.getDocumentStatus());
        EchoTestHelper.fireDialogButton((PopupDialog)dialog, "apply");
        this.fireUpdateButtonConfirmation("no");
        Assert.assertEquals((Object)DocumentActEditor.DocumentStatus.UP_TO_DATE, (Object)editor.getDocumentStatus());
        this.processQueuedTasks();
        Assert.assertEquals((Object)docRef1, (Object)this.act.getDocument());
        editor.documentAttributeModified(false);
        Assert.assertEquals((Object)DocumentActEditor.DocumentStatus.PROMPT, (Object)editor.getDocumentStatus());
        EchoTestHelper.fireDialogButton((PopupDialog)dialog, "apply");
        this.fireUpdateButtonConfirmation("yes");
        this.processQueuedTasks(10, () -> !Objects.equals(this.act.getDocument(), docRef1));
        Assert.assertEquals((Object)DocumentActEditor.DocumentStatus.UP_TO_DATE, (Object)editor.getDocumentStatus());
        Reference docRef2 = this.act.getDocument();
        Assert.assertNotNull((Object)docRef2);
        Assert.assertNotNull((Object)this.get(docRef2));
        editor.documentAttributeModified(false);
        Assert.assertEquals((Object)DocumentActEditor.DocumentStatus.PROMPT, (Object)editor.getDocumentStatus());
        editor.documentAttributeModified(true);
        Assert.assertEquals((Object)DocumentActEditor.DocumentStatus.NEEDS_UPDATE, (Object)editor.getDocumentStatus());
        EchoTestHelper.fireDialogButton((PopupDialog)dialog, "apply");
        this.processQueuedTasks(10, () -> !Objects.equals(this.act.getDocument(), docRef2));
        Assert.assertEquals((Object)DocumentActEditor.DocumentStatus.UP_TO_DATE, (Object)editor.getDocumentStatus());
        Reference docRef3 = this.act.getDocument();
        Assert.assertNotNull((Object)docRef3);
        Assert.assertNotNull((Object)this.get(docRef3));
        editor.documentAttributeModified(false);
        Assert.assertEquals((Object)DocumentActEditor.DocumentStatus.PROMPT, (Object)editor.getDocumentStatus());
        EchoTestHelper.fireDialogButton((PopupDialog)dialog, "apply");
        this.fireUpdateButtonConfirmation("cancel");
        this.processQueuedTasks();
        Assert.assertEquals((Object)DocumentActEditor.DocumentStatus.PROMPT, (Object)editor.getDocumentStatus());
        Assert.assertEquals((Object)docRef3, (Object)this.act.getDocument());
    }

    @Test
    public void testOK() {
        DocumentActEditor editor = this.createEditor();
        Assert.assertEquals((Object)DocumentActEditor.DocumentStatus.UP_TO_DATE, (Object)editor.getDocumentStatus());
        DocumentActEditDialog dialog1 = this.createDialog(editor);
        dialog1.show();
        editor.setTemplate(this.createDocumentTemplate());
        Assert.assertEquals((Object)DocumentActEditor.DocumentStatus.NEEDS_UPDATE, (Object)editor.getDocumentStatus());
        EchoTestHelper.fireDialogButton((PopupDialog)dialog1, "ok");
        this.processQueuedTasks(10, () -> this.act.getDocument() != null);
        Assert.assertEquals((Object)DocumentActEditor.DocumentStatus.UP_TO_DATE, (Object)editor.getDocumentStatus());
        Reference docRef1 = this.act.getDocument();
        Assert.assertNotNull((Object)docRef1);
        Assert.assertNotNull((Object)this.get(docRef1));
        Assert.assertNull((Object)dialog1.getParent());
    }

    @Test
    public void testOKWithSimplePropertyChange() {
        DocumentActEditor editor = this.createEditorWithDocument();
        Reference docRef = this.act.getDocument();
        Assert.assertNotNull((Object)docRef);
        DocumentActEditDialog dialog = this.createDialog(editor);
        dialog.show();
        Assert.assertNotNull((Object)dialog.getParent());
        editor.getProperty("description").setValue((Object)"a description");
        Assert.assertEquals((Object)DocumentActEditor.DocumentStatus.UP_TO_DATE, (Object)editor.getDocumentStatus());
        EchoTestHelper.fireDialogButton((PopupDialog)dialog, "ok");
        this.processQueuedTasks();
        Assert.assertEquals((Object)docRef, (Object)this.act.getDocument());
        Assert.assertNull((Object)dialog.getParent());
    }

    @Test
    public void testOKWithMandatoryUpdate() {
        DocumentActEditor editor = this.createEditorWithDocument();
        Reference docRef1 = this.act.getDocument();
        Assert.assertNotNull((Object)docRef1);
        DocumentActEditDialog dialog = this.createDialog(editor);
        dialog.show();
        editor.documentAttributeModified(true);
        Assert.assertEquals((Object)DocumentActEditor.DocumentStatus.NEEDS_UPDATE, (Object)editor.getDocumentStatus());
        EchoTestHelper.fireDialogButton((PopupDialog)dialog, "ok");
        this.processQueuedTasks(10, () -> !Objects.equals(this.act.getDocument(), docRef1));
        Assert.assertEquals((Object)DocumentActEditor.DocumentStatus.UP_TO_DATE, (Object)editor.getDocumentStatus());
        Reference docRef2 = this.act.getDocument();
        Assert.assertNotNull((Object)docRef2);
        Assert.assertNotEquals((Object)docRef1, (Object)docRef2);
        Assert.assertNotNull((Object)this.get(docRef2));
        Assert.assertNull((Object)dialog.getParent());
    }

    @Test
    public void testOKWithYesPrompt() {
        DocumentActEditor editor = this.createEditorWithDocument();
        Reference docRef1 = this.act.getDocument();
        Assert.assertNotNull((Object)docRef1);
        DocumentActEditDialog dialog = this.createDialog(editor);
        dialog.show();
        Assert.assertNotNull((Object)dialog.getParent());
        editor.documentAttributeModified(false);
        Assert.assertEquals((Object)DocumentActEditor.DocumentStatus.PROMPT, (Object)editor.getDocumentStatus());
        EchoTestHelper.fireDialogButton((PopupDialog)dialog, "ok");
        this.fireUpdateButtonConfirmation("yes");
        this.processQueuedTasks(10, () -> !Objects.equals(this.act.getDocument(), docRef1));
        Assert.assertEquals((Object)DocumentActEditor.DocumentStatus.UP_TO_DATE, (Object)editor.getDocumentStatus());
        Reference docRef2 = this.act.getDocument();
        Assert.assertNotNull((Object)docRef2);
        Assert.assertNotEquals((Object)docRef1, (Object)docRef2);
        Assert.assertNotNull((Object)this.get(docRef2));
        Assert.assertNull((Object)dialog.getParent());
    }

    @Test
    public void testOKWithNoPrompt() {
        DocumentActEditor editor = this.createEditorWithDocument();
        Reference docRef = this.act.getDocument();
        Assert.assertNotNull((Object)docRef);
        DocumentActEditDialog dialog = this.createDialog(editor);
        dialog.show();
        Assert.assertNotNull((Object)dialog.getParent());
        editor.documentAttributeModified(false);
        Assert.assertEquals((Object)DocumentActEditor.DocumentStatus.PROMPT, (Object)editor.getDocumentStatus());
        EchoTestHelper.fireDialogButton((PopupDialog)dialog, "ok");
        this.fireUpdateButtonConfirmation("no");
        Assert.assertEquals((Object)DocumentActEditor.DocumentStatus.UP_TO_DATE, (Object)editor.getDocumentStatus());
        this.processQueuedTasks();
        Assert.assertEquals((Object)docRef, (Object)this.act.getDocument());
        Assert.assertNull((Object)dialog.getParent());
    }

    @Test
    public void testOKWithCancelPrompt() {
        DocumentActEditor editor = this.createEditorWithDocument();
        Reference docRef = this.act.getDocument();
        Assert.assertNotNull((Object)docRef);
        DocumentActEditDialog dialog = this.createDialog(editor);
        dialog.show();
        editor.documentAttributeModified(false);
        Assert.assertEquals((Object)DocumentActEditor.DocumentStatus.PROMPT, (Object)editor.getDocumentStatus());
        EchoTestHelper.fireDialogButton((PopupDialog)dialog, "ok");
        this.fireUpdateButtonConfirmation("cancel");
        this.processQueuedTasks();
        Assert.assertEquals((Object)DocumentActEditor.DocumentStatus.PROMPT, (Object)editor.getDocumentStatus());
        Assert.assertNotNull((Object)dialog.getParent());
        Assert.assertEquals((Object)docRef, (Object)this.act.getDocument());
    }

    protected Entity createDocumentTemplate() {
        return (Entity)((TestDocumentTemplateBuilder)((TestDocumentTemplateBuilder)this.documentFactory.newTemplate().type("act.customerDocumentLetter").blankDocument()).name("blank")).build();
    }

    private void fireUpdateButtonConfirmation(String buttonId) {
        String prompt = "One or more attributes have changed.\n\nDo you want to update the document?";
        EchoTestHelper.findMessageDialogAndFireButton(ConfirmationDialog.class, "Update Document", prompt, buttonId);
    }

    private DocumentActEditDialog createDialog(DocumentActEditor editor) {
        return new DocumentActEditDialog(editor, this.context);
    }

    private DocumentActEditor createEditor() {
        return new DocumentActEditor(this.act, null, (LayoutContext)new DefaultLayoutContext(this.context, new HelpContext("foo", null)));
    }

    private DocumentActEditor createEditorWithDocument() {
        DocumentActEditor editor = this.createEditor();
        editor.setTemplate(this.createDocumentTemplate());
        editor.generateDocument(success -> {
            Assert.assertNotNull((Object)success);
            Assert.assertTrue((boolean)success);
        });
        this.processQueuedTasks(10, () -> this.act.getDocument() != null);
        Assert.assertNotNull((Object)this.act.getDocument());
        Assert.assertTrue((boolean)SaveHelper.save((IMObjectEditor)editor));
        return editor;
    }
}

