/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.im.contact;

import org.junit.Assert;
import org.junit.Test;
import org.openvpms.archetype.test.builder.customer.TestCustomerBuilder;
import org.openvpms.archetype.test.builder.customer.TestCustomerFactory;
import org.openvpms.archetype.test.builder.party.TestContactFactory;
import org.openvpms.archetype.test.builder.party.TestPhoneContactBuilder;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Contact;
import org.openvpms.component.model.party.Party;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.app.LocalContext;
import org.openvpms.web.component.im.contact.ContactCollectionEditor;
import org.openvpms.web.component.im.edit.IMObjectEditor;
import org.openvpms.web.component.im.layout.DefaultLayoutContext;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.property.CollectionProperty;
import org.openvpms.web.component.property.PropertySet;
import org.openvpms.web.component.property.PropertySetBuilder;
import org.openvpms.web.echo.help.HelpContext;
import org.openvpms.web.test.AbstractAppTest;
import org.springframework.beans.factory.annotation.Autowired;

public class ContactCollectionEditorTestCase
extends AbstractAppTest {
    @Autowired
    private TestContactFactory contactFactory;
    @Autowired
    private TestCustomerFactory customerFactory;

    @Test
    public void testExcludeUnmodifiedContacts() {
        Contact phone1 = this.contactFactory.newPhone().areaCode("03").phone("987654321").build();
        Party customer = (Party)((TestCustomerBuilder)this.customerFactory.newCustomer().name("Foo", "Bar").addContact(phone1)).build();
        PropertySet set = new PropertySetBuilder((IMObject)customer).build();
        CollectionProperty property = (CollectionProperty)set.get("contacts");
        DefaultLayoutContext context = new DefaultLayoutContext((Context)new LocalContext(), new HelpContext("foo", null));
        ContactCollectionEditor editor = new ContactCollectionEditor(property, (IMObject)customer, (LayoutContext)context);
        editor.setExcludeUnmodifiedContacts(true);
        editor.getComponent();
        Contact phone2 = (Contact)this.create("contact.phoneNumber", Contact.class);
        Contact location = (Contact)this.create("contact.location", Contact.class);
        Contact email = (Contact)this.create("contact.email", Contact.class);
        editor.add((IMObject)phone2);
        editor.add((IMObject)location);
        editor.add((IMObject)email);
        Assert.assertTrue((boolean)customer.getContacts().contains(phone1));
        Assert.assertFalse((boolean)customer.getContacts().contains(phone2));
        Assert.assertFalse((boolean)customer.getContacts().contains(location));
        Assert.assertFalse((boolean)customer.getContacts().contains(email));
        Assert.assertTrue((boolean)editor.getCurrentObjects().contains(phone1));
        Assert.assertTrue((boolean)editor.getCurrentObjects().contains(phone2));
        Assert.assertTrue((boolean)editor.getCurrentObjects().contains(location));
        Assert.assertTrue((boolean)editor.getCurrentObjects().contains(email));
        IMObjectEditor phoneEditor = editor.getEditor((IMObject)phone2);
        Assert.assertNotNull((Object)phoneEditor);
        phoneEditor.getProperty("telephoneNumber").setValue((Object)"12345678");
        Assert.assertFalse((boolean)customer.getContacts().contains(phone2));
        Assert.assertTrue((boolean)editor.isValid());
        Assert.assertTrue((boolean)customer.getContacts().contains(phone2));
        Assert.assertTrue((boolean)customer.getContacts().contains(phone1));
        Assert.assertFalse((boolean)customer.getContacts().contains(location));
        Assert.assertFalse((boolean)customer.getContacts().contains(email));
        editor.remove((IMObject)email);
        Assert.assertFalse((boolean)editor.getCurrentObjects().contains(email));
        Assert.assertTrue((boolean)editor.getCurrentObjects().contains(phone1));
        Assert.assertTrue((boolean)editor.getCurrentObjects().contains(phone2));
        Assert.assertTrue((boolean)editor.getCurrentObjects().contains(location));
        editor.remove((IMObject)phone2);
        Assert.assertFalse((boolean)editor.getCurrentObjects().contains(email));
        Assert.assertTrue((boolean)editor.getCurrentObjects().contains(phone1));
        Assert.assertFalse((boolean)editor.getCurrentObjects().contains(phone2));
        Assert.assertTrue((boolean)editor.getCurrentObjects().contains(location));
        Assert.assertTrue((boolean)customer.getContacts().contains(phone1));
        Assert.assertFalse((boolean)customer.getContacts().contains(phone2));
        Assert.assertFalse((boolean)customer.getContacts().contains(location));
        Assert.assertFalse((boolean)customer.getContacts().contains(email));
    }

    @Test
    public void testExcludeUnmodifiedContactsWithSave() {
        Party customer = (Party)this.customerFactory.newCustomer().name("Foo", "Bar").build(false);
        PropertySet set = new PropertySetBuilder((IMObject)customer).build();
        CollectionProperty property = (CollectionProperty)set.get("contacts");
        DefaultLayoutContext context = new DefaultLayoutContext((Context)new LocalContext(), new HelpContext("foo", null));
        ContactCollectionEditor editor = new ContactCollectionEditor(property, (IMObject)customer, (LayoutContext)context);
        editor.setExcludeUnmodifiedContacts(true);
        editor.getComponent();
        IMObjectEditor contactEditor1 = editor.add("contact.location");
        Assert.assertNotNull((Object)contactEditor1);
        Contact location1 = (Contact)contactEditor1.getObject();
        Assert.assertFalse((boolean)customer.getContacts().contains(location1));
        IMObjectEditor contactEditor2 = editor.add("contact.location");
        Assert.assertNotNull((Object)contactEditor2);
        Assert.assertSame((Object)contactEditor1, (Object)contactEditor2);
        contactEditor1.getProperty("address").setValue((Object)"Test");
        Assert.assertTrue((boolean)editor.isValid());
        editor.save();
        Assert.assertTrue((boolean)customer.getContacts().contains(location1));
        IMObjectEditor contactEditor3 = editor.add("contact.location");
        Assert.assertNotNull((Object)contactEditor3);
        Assert.assertNotSame((Object)contactEditor1, (Object)contactEditor3);
    }

    @Test
    public void testExistingPreferred() {
        Contact phone1 = ((TestPhoneContactBuilder)this.contactFactory.newPhone().areaCode("03").phone("987654321").preferred(true)).build();
        Party customer = (Party)((TestCustomerBuilder)this.customerFactory.newCustomer().name("Foo", "Bar").addContact(phone1)).build();
        PropertySet set = new PropertySetBuilder((IMObject)customer).build();
        CollectionProperty property = (CollectionProperty)set.get("contacts");
        DefaultLayoutContext context = new DefaultLayoutContext((Context)new LocalContext(), new HelpContext("foo", null));
        ContactCollectionEditor editor = new ContactCollectionEditor(property, (IMObject)customer, (LayoutContext)context);
        editor.setExcludeUnmodifiedContacts(true);
        editor.getComponent();
        this.checkPreferred((IMObject)phone1, true);
        IMObjectEditor phone2Editor = editor.add("contact.phoneNumber");
        Assert.assertNotNull((Object)phone2Editor);
        this.checkPreferred(phone2Editor.getObject(), false);
        IMObjectEditor locationEditor = editor.add("contact.location");
        Assert.assertNotNull((Object)locationEditor);
        locationEditor.getProperty("address").setValue((Object)"123 Foo St");
        this.checkPreferred(locationEditor.getObject(), true);
        this.save((IMObject)customer);
        phone1 = (Contact)this.get((IMObject)phone1);
        this.checkPreferred((IMObject)phone1, true);
    }

    @Test
    public void testSetPreferredTurnsOffExistingPreferred() {
        Contact phone1 = ((TestPhoneContactBuilder)this.contactFactory.newPhone().areaCode("03").phone("987654321").preferred(true)).build();
        Party customer = (Party)((TestCustomerBuilder)this.customerFactory.newCustomer().name("Foo", "Bar").addContact(phone1)).build();
        PropertySet set = new PropertySetBuilder((IMObject)customer).build();
        CollectionProperty property = (CollectionProperty)set.get("contacts");
        DefaultLayoutContext context = new DefaultLayoutContext((Context)new LocalContext(), new HelpContext("foo", null));
        ContactCollectionEditor editor = new ContactCollectionEditor(property, (IMObject)customer, (LayoutContext)context);
        editor.setExcludeUnmodifiedContacts(true);
        editor.getComponent();
        this.checkPreferred((IMObject)phone1, true);
        IMObjectEditor locationEditor = editor.add("contact.location");
        Assert.assertNotNull((Object)locationEditor);
        locationEditor.getProperty("address").setValue((Object)"123 Bar St");
        this.checkPreferred(locationEditor.getObject(), true);
        this.checkPreferred((IMObject)phone1, true);
        IMObjectEditor phone2Editor = editor.add("contact.phoneNumber");
        Assert.assertNotNull((Object)phone2Editor);
        this.checkPreferred(phone2Editor.getObject(), false);
        phone2Editor.getProperty("preferred").setValue((Object)true);
        this.checkPreferred(phone2Editor.getObject(), true);
        this.checkPreferred((IMObject)phone1, false);
        this.checkPreferred(locationEditor.getObject(), true);
    }

    @Test
    public void testDefaultContact() {
        Party customer = (Party)this.customerFactory.newCustomer().build(false);
        PropertySet set = new PropertySetBuilder((IMObject)customer).build();
        CollectionProperty property = (CollectionProperty)set.get("contacts");
        Assert.assertEquals((Object)"contact.phoneNumber", (Object)property.getArchetypes().getDefaultArchetype());
        DefaultLayoutContext context = new DefaultLayoutContext((Context)new LocalContext(), new HelpContext("foo", null));
        ContactCollectionEditor collectionEditor = new ContactCollectionEditor(property, (IMObject)customer, (LayoutContext)context);
        collectionEditor.getComponent();
        IMObjectEditor editor = collectionEditor.add();
        Assert.assertNotNull((Object)editor);
        Assert.assertTrue((boolean)editor.getObject().isA("contact.phoneNumber"));
    }

    private void checkPreferred(IMObject contact, boolean preferred) {
        IMObjectBean bean = this.getBean(contact);
        Assert.assertEquals((Object)preferred, (Object)bean.getBoolean("preferred"));
    }
}

