/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.error;

import java.io.IOException;
import java.io.Serializable;
import org.hibernate.StaleObjectStateException;
import org.junit.Assert;
import org.junit.Test;
import org.openvpms.archetype.test.ArchetypeServiceTest;
import org.openvpms.component.business.domain.im.common.IMObjectReference;
import org.openvpms.component.business.service.archetype.ArchetypeServiceException;
import org.openvpms.component.business.service.archetype.ValidationException;
import org.openvpms.component.business.service.security.ArchetypeAccessDeniedException;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.service.archetype.ValidationError;
import org.openvpms.report.i18n.ReportMessages;
import org.openvpms.report.openoffice.OpenOfficeConnectionException;
import org.openvpms.report.openoffice.OpenOfficeDocumentException;
import org.openvpms.report.openoffice.OpenOfficeException;
import org.openvpms.web.component.error.ErrorFormatter;
import org.springframework.transaction.UnexpectedRollbackException;

public class ErrorFormatterTestCase
extends ArchetypeServiceTest {
    private final OpenOfficeConnectionException openOfficeConnectionException = new OpenOfficeConnectionException(ReportMessages.failedToConnectToOpenOffice((String)"foo"), (Throwable)new IOException("foo"));
    private final ArchetypeServiceException archetypeServiceException = new ArchetypeServiceException(ArchetypeServiceException.ErrorCode.FailedToSaveObject, (Throwable)new StaleObjectStateException("foo", (Serializable)Integer.valueOf(12)));

    @Test
    public void testFormatException() {
        Assert.assertEquals((Object)"An internal application error has occurred.", (Object)ErrorFormatter.format((Throwable)new NullPointerException()));
        Assert.assertEquals((Object)"There is not enough memory to perform this operation.\n\nContact your administrator if the problem persists.", (Object)ErrorFormatter.format((Throwable)new OutOfMemoryError()));
        Assert.assertEquals((Object)"Failed to save object. It may have been changed by another user.", (Object)ErrorFormatter.format((Throwable)this.archetypeServiceException));
        Assert.assertEquals((Object)"REPORT-0080: Failed to connect to OpenOffice: foo", (Object)ErrorFormatter.format((Throwable)this.openOfficeConnectionException));
        Assert.assertEquals((Object)"foo", (Object)ErrorFormatter.format((Throwable)new IOException("foo")));
    }

    @Test
    public void testFormatHTMLException() {
        Assert.assertEquals((Object)"An internal application error has occurred.", (Object)ErrorFormatter.format((Throwable)new NullPointerException()));
        Assert.assertEquals((Object)"Failed to save object. It may have been changed by another user.", (Object)ErrorFormatter.formatHTML((Throwable)this.archetypeServiceException));
        Assert.assertEquals((Object)"REPORT-0080: Failed to connect to OpenOffice: foo.<br/><br/>Please refer to <a href=\"https://openvpms.org/documentation/csh/2.4/topics/troubleshooting#oofailedtoconnect\">the documentation</a> to troubleshoot this issue.", (Object)ErrorFormatter.formatHTML((Throwable)this.openOfficeConnectionException));
        Assert.assertEquals((Object)"foo", (Object)ErrorFormatter.formatHTML((Throwable)new IOException("foo")));
    }

    @Test
    public void testFormatExceptionWithDisplayName() {
        Assert.assertEquals((Object)"An internal application error has occurred.", (Object)ErrorFormatter.format((Throwable)new NullPointerException(), (String)"Payment"));
        Assert.assertEquals((Object)"The Payment could not be saved. It may have been changed by another user.", (Object)ErrorFormatter.format((Throwable)this.archetypeServiceException, (String)"Payment"));
        Assert.assertEquals((Object)"REPORT-0080: Failed to connect to OpenOffice: foo", (Object)ErrorFormatter.format((Throwable)this.openOfficeConnectionException, (String)"Payment"));
        Assert.assertEquals((Object)"foo", (Object)ErrorFormatter.format((Throwable)new IOException("foo"), (String)"Payment"));
    }

    @Test
    public void testEscapePlainTextForHTMLMessages() {
        org.openvpms.component.business.service.archetype.ValidationError error = new org.openvpms.component.business.service.archetype.ValidationError((Reference)new IMObjectReference("party.patientpet", 10L), "name", "Fi<do>");
        ValidationException exception = new ValidationException("party.patientpet", (ValidationError)error);
        Assert.assertEquals((Object)"Failed to validate Name of Patient (Pet): Fi&lt;do&gt;", (Object)ErrorFormatter.formatHTML((Throwable)exception));
        Assert.assertEquals((Object)"Failed to validate Name of Patient (Pet): Fi&lt;do&gt;", (Object)ErrorFormatter.formatHTML((Throwable)exception, (String)"Patient"));
        Assert.assertEquals((Object)"REPORT-0080: Failed to connect to OpenOffice: &lt;some error&gt;.<br/><br/>Please refer to <a href=\"https://openvpms.org/documentation/csh/2.4/topics/troubleshooting#oofailedtoconnect\">the documentation</a> to troubleshoot this issue.", (Object)ErrorFormatter.formatHTML((Throwable)new OpenOfficeConnectionException(ReportMessages.failedToConnectToOpenOffice((String)"<some error>"))));
    }

    @Test
    public void testFormatAccessDeniedException() {
        ArchetypeAccessDeniedException accessDeniedException = new ArchetypeAccessDeniedException("foo", "save");
        String expected = "You do not have permission to save instances of foo";
        Assert.assertEquals((Object)expected, (Object)ErrorFormatter.format((Throwable)accessDeniedException));
        Assert.assertEquals((Object)expected, (Object)ErrorFormatter.formatHTML((Throwable)accessDeniedException));
        Assert.assertEquals((Object)expected, (Object)ErrorFormatter.format((Throwable)accessDeniedException, (String)"Payment"));
        Assert.assertEquals((Object)expected, (Object)ErrorFormatter.formatHTML((Throwable)accessDeniedException, (String)"Payment"));
    }

    @Test
    public void testNullPointerException() {
        NullPointerException exception = new NullPointerException();
        String expected = "An internal application error has occurred.";
        Assert.assertEquals((Object)expected, (Object)ErrorFormatter.format((Throwable)exception));
        Assert.assertEquals((Object)expected, (Object)ErrorFormatter.formatHTML((Throwable)exception));
        Assert.assertEquals((Object)expected, (Object)ErrorFormatter.format((Throwable)exception, (String)"Payment"));
        Assert.assertEquals((Object)expected, (Object)ErrorFormatter.formatHTML((Throwable)exception, (String)"Payment"));
        Assert.assertEquals((Object)expected, (Object)ErrorFormatter.format((Throwable)exception, (ErrorFormatter.Category)ErrorFormatter.Category.DEFAULT, (String)"Payment"));
        Assert.assertEquals((Object)expected, (Object)ErrorFormatter.format((Throwable)exception, (ErrorFormatter.Category)ErrorFormatter.Category.DELETE, (String)"Payment"));
    }

    @Test
    public void testFormatStaleObjectStateException() {
        StaleObjectStateException exception = new StaleObjectStateException("foo", (Serializable)Integer.valueOf(12));
        String expected1 = "Failed to save object. It may have been changed by another user.";
        Assert.assertEquals((Object)expected1, (Object)ErrorFormatter.format((Throwable)exception));
        Assert.assertEquals((Object)expected1, (Object)ErrorFormatter.formatHTML((Throwable)exception));
        String expected2 = "The Payment could not be saved. It may have been changed by another user.";
        Assert.assertEquals((Object)expected2, (Object)ErrorFormatter.format((Throwable)exception, (String)"Payment"));
        Assert.assertEquals((Object)expected2, (Object)ErrorFormatter.formatHTML((Throwable)exception, (String)"Payment"));
        Assert.assertEquals((Object)expected2, (Object)ErrorFormatter.format((Throwable)exception, (ErrorFormatter.Category)ErrorFormatter.Category.DEFAULT, (String)"Payment"));
        Assert.assertEquals((Object)expected2, (Object)ErrorFormatter.formatHTML((Throwable)exception, (ErrorFormatter.Category)ErrorFormatter.Category.DEFAULT, (String)"Payment"));
        Assert.assertEquals((Object)expected2, (Object)ErrorFormatter.formatHTML((Throwable)exception, (ErrorFormatter.Category)ErrorFormatter.Category.DEFAULT, (String)"Payment"));
        String expected3 = "The Payment could not be deleted. It may have been changed by another user.";
        Assert.assertEquals((Object)expected3, (Object)ErrorFormatter.format((Throwable)exception, (ErrorFormatter.Category)ErrorFormatter.Category.DELETE, (String)"Payment"));
        Assert.assertEquals((Object)expected3, (Object)ErrorFormatter.formatHTML((Throwable)exception, (ErrorFormatter.Category)ErrorFormatter.Category.DELETE, (String)"Payment"));
    }

    @Test
    public void testFormatUnexpectedRollbackException() {
        UnexpectedRollbackException exception = new UnexpectedRollbackException("foo");
        String expected1 = "Failed to save object. It may have been changed by another user";
        Assert.assertEquals((Object)expected1, (Object)ErrorFormatter.format((Throwable)exception));
        Assert.assertEquals((Object)expected1, (Object)ErrorFormatter.formatHTML((Throwable)exception));
        String expected2 = "The Payment could not be saved. It may have been changed by another user.";
        Assert.assertEquals((Object)expected2, (Object)ErrorFormatter.format((Throwable)exception, (String)"Payment"));
        Assert.assertEquals((Object)expected2, (Object)ErrorFormatter.formatHTML((Throwable)exception, (String)"Payment"));
        Assert.assertEquals((Object)expected2, (Object)ErrorFormatter.format((Throwable)exception, (ErrorFormatter.Category)ErrorFormatter.Category.DEFAULT, (String)"Payment"));
        Assert.assertEquals((Object)expected2, (Object)ErrorFormatter.formatHTML((Throwable)exception, (ErrorFormatter.Category)ErrorFormatter.Category.DEFAULT, (String)"Payment"));
        String expected3 = "The Payment could not be deleted. It may have been changed by another user.";
        Assert.assertEquals((Object)expected3, (Object)ErrorFormatter.format((Throwable)exception, (ErrorFormatter.Category)ErrorFormatter.Category.DELETE, (String)"Payment"));
        Assert.assertEquals((Object)expected3, (Object)ErrorFormatter.formatHTML((Throwable)exception, (ErrorFormatter.Category)ErrorFormatter.Category.DELETE, (String)"Payment"));
    }

    @Test
    public void testFormatValidationException() {
        org.openvpms.component.business.service.archetype.ValidationError error = new org.openvpms.component.business.service.archetype.ValidationError((Reference)new IMObjectReference("party.patientpet", 10L), "species", "foo");
        ValidationException exception = new ValidationException("party.patientpet", (ValidationError)error);
        String expected = "Failed to validate Species of Patient (Pet): foo";
        Assert.assertEquals((Object)expected, (Object)ErrorFormatter.format((Throwable)exception));
        Assert.assertEquals((Object)expected, (Object)ErrorFormatter.formatHTML((Throwable)exception));
        Assert.assertEquals((Object)expected, (Object)ErrorFormatter.format((Throwable)exception, (String)"Bar"));
        Assert.assertEquals((Object)expected, (Object)ErrorFormatter.formatHTML((Throwable)exception, (String)"Bar"));
    }

    @Test
    public void testFormatOpenOfficeException() {
        OpenOfficeException exception = new OpenOfficeException(ReportMessages.failedToPrintOpenOfficeDocument((String)"foo"));
        String expected = "REPORT-0065: Failed to print 'foo'\n\nContact your administrator if the problem persists.";
        Assert.assertEquals((Object)expected, (Object)ErrorFormatter.format((Throwable)exception));
        Assert.assertEquals((Object)expected, (Object)ErrorFormatter.formatHTML((Throwable)exception));
        Assert.assertEquals((Object)expected, (Object)ErrorFormatter.format((Throwable)exception, (String)"Payment"));
        Assert.assertEquals((Object)expected, (Object)ErrorFormatter.formatHTML((Throwable)exception, (String)"Payment"));
    }

    public void testFormatOpenOfficeConnectionException() {
        String expected1 = "Failed to connect to OpenOffice: bar";
        Assert.assertEquals((Object)expected1, (Object)ErrorFormatter.format((Throwable)this.openOfficeConnectionException));
        Assert.assertEquals((Object)expected1, (Object)ErrorFormatter.format((Throwable)this.openOfficeConnectionException, (String)"Payment"));
        String expected2 = "Failed to connect to OpenOffice: bar.<br/><br/>Please refer to <a href=\"https://openvpms.org/documentation/csh/2.2/topics/troubleshooting#oofailedtoconnect\">the documentation</a> to troubleshoot this issue.";
        Assert.assertEquals((Object)expected2, (Object)ErrorFormatter.formatHTML((Throwable)this.openOfficeConnectionException));
        Assert.assertEquals((Object)expected2, (Object)ErrorFormatter.formatHTML((Throwable)this.openOfficeConnectionException, (String)"Payment"));
    }

    @Test
    public void testFormatOpenOfficeDocumentException() {
        OpenOfficeDocumentException exception = new OpenOfficeDocumentException(ReportMessages.failedToLoadOpenOfficeDocument((String)"foo"));
        String expected1 = "REPORT-0060: Failed to load 'foo' into OpenOffice";
        Assert.assertEquals((Object)expected1, (Object)ErrorFormatter.format((Throwable)exception));
        Assert.assertEquals((Object)expected1, (Object)ErrorFormatter.format((Throwable)exception, (String)"Payment"));
        String expected2 = "REPORT-0060: Failed to load 'foo' into OpenOffice.<br/><br/>Please refer to <a href=\"https://openvpms.org/documentation/csh/2.4/topics/troubleshooting#oodocumentexception\">the documentation</a> to troubleshoot this issue.";
        Assert.assertEquals((Object)expected2, (Object)ErrorFormatter.formatHTML((Throwable)exception));
        Assert.assertEquals((Object)expected2, (Object)ErrorFormatter.formatHTML((Throwable)exception, (String)"Payment"));
    }
}

