/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.bound;

import java.sql.Timestamp;
import java.util.Date;
import nextapp.echo2.app.Component;
import org.junit.Assert;
import org.junit.Test;
import org.openvpms.archetype.rules.util.DateRules;
import org.openvpms.archetype.rules.util.DateUnits;
import org.openvpms.web.component.bound.AbstractBoundFieldTest;
import org.openvpms.web.component.bound.BoundDateTimeField;
import org.openvpms.web.component.property.Property;
import org.openvpms.web.component.property.SimpleProperty;

public class BoundDateTimeFieldTestCase
extends AbstractBoundFieldTest<BoundDateTimeField, Date> {
    private static final Date value1 = new Date(Timestamp.valueOf("2009-01-01 10:30:00").getTime());
    private static final Date value2 = new Date(Timestamp.valueOf("2011-01-01 00:00:00").getTime());

    public BoundDateTimeFieldTestCase() {
        super(value1, value2);
    }

    @Test
    public void testSetDateAndTime() {
        Property property = this.createProperty();
        BoundDateTimeField field = this.createField(property);
        field.setDate((Date)java.sql.Date.valueOf("2010-12-31"));
        field.getTimeField().setText("10:30");
        Date expected1 = new Date(Timestamp.valueOf("2010-12-31 10:30:00").getTime());
        Assert.assertEquals((Object)expected1, (Object)field.getProperty().getValue());
        field.setDate((Date)java.sql.Date.valueOf("2010-10-11"));
        Date expected2 = new Date(Timestamp.valueOf("2010-10-11 10:30:00").getTime());
        Assert.assertEquals((Object)expected2, (Object)field.getProperty().getValue());
        field.getTimeField().setText("11:30");
        Date expected3 = new Date(Timestamp.valueOf("2010-10-11 11:30:00").getTime());
        Assert.assertEquals((Object)expected3, (Object)field.getProperty().getValue());
    }

    @Test
    public void testSetNullDateViaText() {
        java.sql.Date date = java.sql.Date.valueOf("2010-12-31");
        Property property = this.createProperty();
        BoundDateTimeField field = this.createField(property);
        field.setDate((Date)date);
        Assert.assertEquals((Object)date, (Object)property.getValue());
        field.getDateField().getTextField().setText(null);
        Assert.assertNull((Object)property.getValue());
    }

    @Test
    public void testDateRange() {
        Property property = this.createProperty();
        BoundDateTimeField field = this.createField(property);
        Date minDate = field.getMinDate();
        Date maxDate = field.getMaxDate();
        Assert.assertNotNull((Object)minDate);
        Assert.assertNotNull((Object)maxDate);
        Date belowMinDate = DateRules.getDate((Date)minDate, (int)-1, (DateUnits)DateUnits.DAYS);
        Date belowMaxDate = DateRules.getDate((Date)maxDate, (int)-1, (DateUnits)DateUnits.DAYS);
        Date aboveMaxDate = DateRules.getDate((Date)maxDate, (int)1, (DateUnits)DateUnits.DAYS);
        field.setDate(belowMinDate);
        Assert.assertNull((Object)property.getValue());
        Assert.assertFalse((boolean)property.isValid());
        field.setDatetime(minDate);
        Assert.assertEquals((Object)minDate, (Object)property.getValue());
        Assert.assertTrue((boolean)property.isValid());
        field.setDatetime(belowMaxDate);
        Assert.assertEquals((Object)belowMaxDate, (Object)property.getValue());
        Assert.assertTrue((boolean)property.isValid());
        field.setDatetime(maxDate);
        Assert.assertEquals((Object)belowMaxDate, (Object)property.getValue());
        Assert.assertFalse((boolean)property.isValid());
        field.setDate(aboveMaxDate);
        Assert.assertEquals((Object)belowMaxDate, (Object)property.getValue());
        Assert.assertFalse((boolean)property.isValid());
        field.setDate(belowMaxDate);
        Assert.assertEquals((Object)belowMaxDate, (Object)property.getValue());
        Assert.assertTrue((boolean)property.isValid());
    }

    @Override
    protected Date getValue(BoundDateTimeField field) {
        return field.getDatetime();
    }

    @Override
    protected void setValue(BoundDateTimeField field, Date value) {
        field.setDatetime(value);
    }

    @Override
    protected BoundDateTimeField createField(Property property) {
        return new BoundDateTimeField(property);
    }

    @Override
    protected Property createProperty() {
        return new SimpleProperty("datetime", Date.class);
    }

    @Override
    protected void addComponent(Component container, BoundDateTimeField field) {
        container.add(field.getComponent());
    }

    @Override
    protected void removeComponent(Component container, BoundDateTimeField field) {
        container.remove(field.getComponent());
    }
}

