/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.bound;

import java.sql.Time;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.junit.Assert;
import org.junit.Test;
import org.openvpms.web.component.bound.AbstractBoundFieldTest;
import org.openvpms.web.component.bound.BoundAbsoluteTimeField;
import org.openvpms.web.component.property.DefaultValidator;
import org.openvpms.web.component.property.Modifiable;
import org.openvpms.web.component.property.Property;
import org.openvpms.web.component.property.SimpleProperty;
import org.openvpms.web.component.property.Validator;
import org.openvpms.web.component.property.ValidatorError;
import org.openvpms.web.resource.i18n.format.DateFormatter;

public class BoundAbsoluteTimeFieldTestCase
extends AbstractBoundFieldTest<BoundAbsoluteTimeField, Date> {
    private static final Date value1 = Time.valueOf("09:00:00");
    private static final Date value2 = Time.valueOf("12:00:00");

    public BoundAbsoluteTimeFieldTestCase() {
        super(value1, value2);
    }

    @Test
    public void testTimeRange() {
        Property property1 = this.createProperty();
        BoundAbsoluteTimeField field1 = new BoundAbsoluteTimeField(property1);
        field1.setText("00:00");
        Assert.assertTrue((boolean)property1.isValid());
        Assert.assertEquals((Object)Time.valueOf("00:00:00"), (Object)property1.getDate());
        field1.setText("24:00");
        this.checkError(property1, "Time must be < than the maximum time 24:00");
        field1.setText("23:59");
        Assert.assertTrue((boolean)property1.isValid());
        Assert.assertEquals((Object)Time.valueOf("23:59:00"), (Object)property1.getDate());
        Property property2 = this.createProperty();
        BoundAbsoluteTimeField field2 = new BoundAbsoluteTimeField(property2, false);
        field2.setText("24:00");
        Assert.assertTrue((boolean)property2.isValid());
        Assert.assertEquals((Object)Time.valueOf("24:00:00"), (Object)property2.getDate());
    }

    private void checkError(Property property, String error) {
        DefaultValidator validator = new DefaultValidator();
        Assert.assertFalse((boolean)property.validate((Validator)validator));
        List errors = validator.getErrors((Modifiable)property);
        Assert.assertEquals((long)1L, (long)errors.size());
        Assert.assertEquals((Object)error, (Object)((ValidatorError)errors.get(0)).getMessage());
    }

    @Override
    protected Date getValue(BoundAbsoluteTimeField field) {
        String text = field.getText();
        return !StringUtils.isEmpty((CharSequence)text) ? Time.valueOf(text + ":00") : null;
    }

    @Override
    protected void setValue(BoundAbsoluteTimeField field, Date value) {
        field.setText(DateFormatter.formatTime((Date)value, (boolean)true));
    }

    @Override
    protected BoundAbsoluteTimeField createField(Property property) {
        return new BoundAbsoluteTimeField(property);
    }

    @Override
    protected Property createProperty() {
        return new SimpleProperty("time", Date.class);
    }
}

