/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.app;

import java.lang.reflect.Method;
import java.util.Date;
import org.apache.commons.beanutils.MethodUtils;
import org.junit.Assert;
import org.junit.Test;
import org.openvpms.archetype.test.ArchetypeServiceTest;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.user.User;
import org.openvpms.web.component.app.AbstractContext;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.app.LocalContext;

public class LocalContextTestCase
extends ArchetypeServiceTest {
    @Test
    public void testContext() throws Exception {
        LocalContext context = this.createContext(true);
        this.checkContext("security.user", "getClinician", context);
        this.checkContext("act.customerAppointment", "getCurrent", context);
        this.checkContext("party.customerperson", "getCustomer", context);
        this.checkContext("party.organisationDeposit", "getDeposit", context);
        this.checkContext("party.organisationLocation", "getLocation", context);
        this.checkContext("party.patientpet", "getPatient", context);
        this.checkContext("party.organisationPractice", "getPractice", context);
        this.checkContext("product.medication", "getProduct", context);
        this.checkContext("entity.organisationScheduleView", "getScheduleView", context);
        this.checkContext("party.organisationSchedule", "getSchedule", context);
        this.checkContext(new Date(), new Date(), "getScheduleDate", context);
        this.checkContext("act.customerAppointment", "getAppointment", context);
        this.checkContext("party.organisationStockLocation", "getStockLocation", context);
        this.checkContext("party.supplierperson", "getSupplier", context);
        this.checkContext("party.organisationTill", "getTill", context);
        this.checkContext("security.user", "getUser", context);
        this.checkContext("party.organisationWorkList", "getWorkList", context);
        this.checkContext(new Date(), new Date(), "getWorkListDate", context);
        this.checkContext("act.customerTask", "getTask", context);
    }

    @Test
    public void testRemoveObject() {
        LocalContext context = this.createContext(true);
        Context parent = context.getParent();
        User user1 = (User)this.create("security.user", User.class);
        User user2 = (User)this.create("security.user", User.class);
        context.setUser(user1);
        parent.setUser(user2);
        context.removeObject((IMObject)user1);
        Assert.assertEquals((Object)user2, (Object)context.getUser());
        context.removeObject((IMObject)user2);
        Assert.assertEquals((Object)user2, (Object)parent.getUser());
        Assert.assertEquals((Object)user2, (Object)context.getUser());
    }

    private void checkContext(String shortName, String method, LocalContext context) throws Exception {
        IMObject object1 = this.create(shortName);
        IMObject object2 = this.create(shortName);
        this.checkContext(object1, object2, method, context);
    }

    private void checkContext(Object obj1, Object obj2, String method, LocalContext context) throws Exception {
        Assert.assertNull((Object)this.get((Context)context, method));
        String setter = method.replaceFirst("get", "set");
        Context parent = context.getParent();
        if (parent != null) {
            this.set(parent, setter, obj1);
            Assert.assertEquals((Object)obj1, (Object)this.get((Context)context, method));
        }
        this.set((Context)context, setter, obj2);
        Assert.assertEquals((Object)obj2, (Object)this.get((Context)context, method));
        if (parent != null) {
            Assert.assertEquals((Object)obj1, (Object)this.get(parent, method));
            this.set(parent, setter, null);
            Assert.assertEquals((Object)obj2, (Object)this.get((Context)context, method));
        }
        this.set((Context)context, setter, null);
        Assert.assertNull((Object)this.get((Context)context, method));
    }

    private LocalContext createContext(boolean withParent) {
        AbstractContext parent = null;
        if (withParent) {
            parent = new AbstractContext(){};
        }
        return new LocalContext(parent);
    }

    private void set(Context context, String methodName, Object value) throws Exception {
        Method[] methods;
        for (Method method : methods = context.getClass().getMethods()) {
            if (!method.getName().equals(methodName)) continue;
            method.invoke((Object)context, value);
            break;
        }
    }

    private Object get(Context context, String method) throws Exception {
        return MethodUtils.invokeMethod((Object)context, (String)method, null);
    }
}

