/*
 * Version: 1.0
 *
 * The contents of this file are subject to the OpenVPMS License Version
 * 1.0 (the 'License'); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.openvpms.org/license/
 *
 * Software distributed under the License is distributed on an 'AS IS' basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * Copyright 2022 (C) OpenVPMS Ltd. All Rights Reserved.
 */

package org.openvpms.web.component.property;

import org.openvpms.component.exception.OpenVPMSException;


/**
 * Exception for {@link Property} instances.
 *
 * @author <a href="mailto:support@openvpms.org">OpenVPMS Team</a>
 */
public class PropertyException extends OpenVPMSException {

    /**
     * The property.
     */
    private final Property property;


    /**
     * Constructs a {@link PropertyException}.
     *
     * @param property the property
     * @param message  the message
     */
    public PropertyException(Property property, String message) {
        super(org.openvpms.component.i18n.Messages.create(message));
        this.property = property;
    }

    /**
     * Constructs a {@link PropertyException}.
     *
     * @param property the property
     * @param message  the message
     * @param cause    the cause of the exception. May be {@link null}
     */
    public PropertyException(Property property, String message, Throwable cause) {
        super(org.openvpms.component.i18n.Messages.create(message), cause);
        this.property = property;
    }

    /**
     * Returns the property that triggered the exception.
     *
     * @return the property
     */
    public Property getProperty() {
        return property;
    }
}
