/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.security.oauth;

import java.time.Instant;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Order;
import javax.persistence.criteria.Predicate;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.query.criteria.CriteriaBuilder;
import org.openvpms.component.query.criteria.CriteriaQuery;
import org.openvpms.component.query.criteria.Root;
import org.openvpms.component.security.crypto.PasswordEncryptor;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.springframework.dao.DataRetrievalFailureException;
import org.springframework.security.core.Authentication;
import org.springframework.security.oauth2.client.OAuth2AuthorizedClient;
import org.springframework.security.oauth2.client.OAuth2AuthorizedClientService;
import org.springframework.security.oauth2.client.registration.ClientRegistration;
import org.springframework.security.oauth2.client.registration.ClientRegistrationRepository;
import org.springframework.security.oauth2.core.OAuth2AccessToken;
import org.springframework.security.oauth2.core.OAuth2RefreshToken;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class OAuth2AuthorizedClientServiceImpl
implements OAuth2AuthorizedClientService {
    private final ClientRegistrationRepository repository;
    private final ArchetypeService service;
    private final PasswordEncryptor encryptor;
    private final Map<Entity, OAuth2AuthorizedClient> cache = Collections.synchronizedMap(new HashMap());
    private static final String OAUTH2_AUTHORIZED_CLIENT = "entity.oauth2AuthorizedClient";
    private static final String CLIENT_REGISTRATION_ID = "clientRegistrationId";
    private static final String PRINCIPAL_NAME = "name";
    private static final String ACCESS_TOKEN = "accessToken";
    private static final String ACCESS_TOKEN_ISSUED_AT = "accessTokenIssuedAt";
    private static final String ACCESS_TOKEN_EXPIRES_AT = "accessTokenExpiresAt";
    private static final String ACCESS_TOKEN_SCOPES = "accessTokenScopes";
    private static final String REFRESH_TOKEN = "refreshToken";
    private static final String REFRESH_TOKEN_ISSUED_AT = "refreshTokenIssuedAt";

    public OAuth2AuthorizedClientServiceImpl(ClientRegistrationRepository repository, ArchetypeService service, PasswordEncryptor encryptor) {
        this.repository = repository;
        this.service = service;
        this.encryptor = encryptor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends OAuth2AuthorizedClient> T loadAuthorizedClient(String clientRegistrationId, String principalName) {
        Entity entity;
        OAuth2AuthorizedClient result;
        Map<Entity, OAuth2AuthorizedClient> map = this.cache;
        synchronized (map) {
            result = this.cache.values().stream().filter(client -> clientRegistrationId.equals(client.getClientRegistration().getClientId()) && principalName.equals(client.getPrincipalName())).findFirst().orElse(null);
        }
        if (result == null && (entity = this.query(clientRegistrationId, principalName)) != null) {
            result = this.map(entity);
            this.cache.put(entity, result);
        }
        return (T)result;
    }

    public void saveAuthorizedClient(OAuth2AuthorizedClient authorizedClient, Authentication principal) {
        String principalName;
        ClientRegistration clientRegistration = authorizedClient.getClientRegistration();
        String clientRegistrationId = clientRegistration.getRegistrationId();
        Entity entity = this.query(clientRegistrationId, principalName = principal.getName());
        if (entity == null) {
            entity = (Entity)this.service.create(OAUTH2_AUTHORIZED_CLIENT, Entity.class);
        }
        IMObjectBean bean = this.service.getBean((IMObject)entity);
        if (entity.isNew()) {
            bean.setValue(CLIENT_REGISTRATION_ID, (Object)clientRegistrationId);
            bean.setValue(PRINCIPAL_NAME, (Object)principalName);
        }
        OAuth2AccessToken accessToken = authorizedClient.getAccessToken();
        OAuth2RefreshToken refreshToken = authorizedClient.getRefreshToken();
        bean.setValue(ACCESS_TOKEN, (Object)this.encryptor.encrypt(accessToken.getTokenValue()));
        bean.setValue(ACCESS_TOKEN_ISSUED_AT, (Object)this.toDate(accessToken.getIssuedAt()));
        bean.setValue(ACCESS_TOKEN_EXPIRES_AT, (Object)this.toDate(accessToken.getExpiresAt()));
        String accessTokenScopes = null;
        if (!CollectionUtils.isEmpty((Collection)accessToken.getScopes())) {
            accessTokenScopes = StringUtils.collectionToDelimitedString((Collection)accessToken.getScopes(), (String)",");
        }
        bean.setValue(ACCESS_TOKEN_SCOPES, accessTokenScopes);
        if (refreshToken != null) {
            bean.setValue(REFRESH_TOKEN, (Object)this.encryptor.encrypt(refreshToken.getTokenValue()));
            bean.setValue(REFRESH_TOKEN_ISSUED_AT, (Object)this.toDate(refreshToken.getIssuedAt()));
        }
        bean.save();
        this.cache.put(entity, authorizedClient);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAuthorizedClient(String clientRegistrationId, String principalName) {
        Entity entity;
        Map<Entity, OAuth2AuthorizedClient> map = this.cache;
        synchronized (map) {
            entity = this.cache.entrySet().stream().filter(entry -> clientRegistrationId.equals(((OAuth2AuthorizedClient)entry.getValue()).getClientRegistration().getClientId()) && principalName.equals(((OAuth2AuthorizedClient)entry.getValue()).getPrincipalName())).map(Map.Entry::getKey).findFirst().orElse(null);
            if (entity != null) {
                this.cache.remove(entity);
            }
        }
        if (entity == null) {
            entity = this.query(clientRegistrationId, principalName);
        }
        if (entity != null) {
            this.service.remove(entity.getObjectReference());
        }
    }

    private OAuth2AuthorizedClient map(Entity entity) {
        IMObjectBean bean = this.service.getBean((IMObject)entity);
        String clientRegistrationId = bean.getString(CLIENT_REGISTRATION_ID);
        ClientRegistration clientRegistration = this.repository.findByRegistrationId(clientRegistrationId);
        if (clientRegistration == null) {
            throw new DataRetrievalFailureException("The ClientRegistration with id '" + clientRegistrationId + "' exists in the data source, however, it was not found in the ClientRegistrationRepository.");
        }
        String tokenValue = this.encryptor.decrypt(bean.getString(ACCESS_TOKEN));
        Instant issuedAt = bean.getDate(ACCESS_TOKEN_ISSUED_AT).toInstant();
        Instant expiresAt = bean.getDate(ACCESS_TOKEN_EXPIRES_AT).toInstant();
        Set scopes = Collections.emptySet();
        String accessTokenScopes = bean.getString(ACCESS_TOKEN_SCOPES);
        if (accessTokenScopes != null) {
            scopes = StringUtils.commaDelimitedListToSet((String)accessTokenScopes);
        }
        OAuth2AccessToken accessToken = new OAuth2AccessToken(OAuth2AccessToken.TokenType.BEARER, tokenValue, issuedAt, expiresAt, scopes);
        OAuth2RefreshToken refreshToken = null;
        String refreshTokenValue = bean.getString(REFRESH_TOKEN);
        if (refreshTokenValue != null) {
            issuedAt = null;
            Date refreshTokenIssuedAt = bean.getDate(REFRESH_TOKEN_ISSUED_AT);
            if (refreshTokenIssuedAt != null) {
                issuedAt = refreshTokenIssuedAt.toInstant();
            }
            refreshToken = new OAuth2RefreshToken(this.encryptor.decrypt(refreshTokenValue), issuedAt);
        }
        return new OAuth2AuthorizedClient(clientRegistration, entity.getName(), accessToken, refreshToken);
    }

    private Date toDate(Instant instant) {
        return instant != null ? Date.from(instant) : null;
    }

    private Entity query(String clientRegistrationId, String principalName) {
        CriteriaBuilder builder = this.service.getCriteriaBuilder();
        CriteriaQuery query = builder.createQuery(Entity.class);
        Root from = query.from(Entity.class, new String[]{OAUTH2_AUTHORIZED_CLIENT});
        query.where(new Predicate[]{builder.equal((Expression)from.get(PRINCIPAL_NAME), (Object)principalName), builder.equal((Expression)from.get(CLIENT_REGISTRATION_ID), (Object)clientRegistrationId)});
        query.orderBy(new Order[]{builder.asc((Expression)from.get("id"))});
        return (Entity)this.service.createQuery(query).getFirstResult();
    }
}

