/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.workspace;

import echopointng.TabbedPane;
import nextapp.echo2.app.Column;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.Label;
import nextapp.echo2.app.LayoutData;
import nextapp.echo2.app.SplitPane;
import nextapp.echo2.app.event.ChangeEvent;
import nextapp.echo2.app.event.ChangeListener;
import nextapp.echo2.app.layout.SplitPaneLayoutData;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.workspace.AbstractWorkspace;
import org.openvpms.web.component.workspace.TabComponent;
import org.openvpms.web.echo.factory.ColumnFactory;
import org.openvpms.web.echo.factory.LabelFactory;
import org.openvpms.web.echo.factory.SplitPaneFactory;
import org.openvpms.web.echo.factory.TabbedPaneFactory;
import org.openvpms.web.echo.help.HelpContext;
import org.openvpms.web.echo.tabpane.ObjectTabPaneModel;
import org.openvpms.web.resource.i18n.Messages;

public abstract class TabbedWorkspace<T extends IMObject>
extends AbstractWorkspace<T> {
    private TabbedPane pane;
    private ObjectTabPaneModel<TabComponent> model;
    private SplitPane container;
    private static final String STYLE = "SplitPaneWithButtonRow";

    public TabbedWorkspace(String id, Context context) {
        super(id, context);
    }

    @Override
    public void show() {
        TabComponent tab = this.getSelected();
        if (tab != null) {
            tab.show();
        }
    }

    @Override
    public HelpContext getHelpContext() {
        TabComponent tab;
        HelpContext result = null;
        if (this.model != null && this.pane != null && (tab = this.getSelected()) != null) {
            result = tab.getHelpContext();
        }
        return result == null ? super.getHelpContext() : result;
    }

    protected TabComponent getSelected() {
        return (TabComponent)this.model.getObject(this.pane.getSelectedIndex());
    }

    protected ObjectTabPaneModel<TabComponent> getModel() {
        return this.model;
    }

    @Override
    protected Component doLayout() {
        Column tabContainer = ColumnFactory.create();
        SplitPaneLayoutData layoutData = new SplitPaneLayoutData();
        layoutData.setOverflow(1);
        tabContainer.setLayoutData((LayoutData)layoutData);
        this.container = SplitPaneFactory.create((int)5, (String)"TabbedBrowser", (Component[])new Component[]{tabContainer});
        this.model = this.createTabModel((Component)tabContainer);
        Component heading = super.doLayout();
        SplitPane root = SplitPaneFactory.create((int)5, (String)STYLE, (Component[])new Component[]{heading, this.container});
        this.pane = TabbedPaneFactory.create(this.model);
        this.pane.setStyleName("VisitEditor.TabbedPane");
        this.pane.getSelectionModel().addChangeListener((ChangeListener)new org.openvpms.web.echo.event.ChangeListener(){

            public void onChange(ChangeEvent event) {
                TabbedWorkspace.this.onTabSelected((TabComponent)TabbedWorkspace.this.model.getObject(TabbedWorkspace.this.pane.getSelectedIndex()));
            }
        });
        tabContainer.add((Component)this.pane);
        this.onTabSelected((TabComponent)this.model.getObject(0));
        return root;
    }

    protected TabbedPane getTabbedPane() {
        return this.pane;
    }

    protected ObjectTabPaneModel<TabComponent> createTabModel(Component container) {
        ObjectTabPaneModel result = new ObjectTabPaneModel(container);
        this.addTabs((ObjectTabPaneModel<TabComponent>)result);
        return result;
    }

    protected abstract void addTabs(ObjectTabPaneModel<TabComponent> var1);

    protected int addTab(String name, ObjectTabPaneModel<TabComponent> model, TabComponent tab) {
        int index = model.size();
        int shortcut = index + 1;
        String text = "&" + shortcut + " " + Messages.get((String)name);
        Label dummy = LabelFactory.create();
        model.addTab((Object)tab, text, (Component)dummy);
        return index;
    }

    protected HelpContext subtopic(String topic) {
        return super.getHelpContext().subtopic(topic);
    }

    private void onTabSelected(TabComponent tab) {
        if (this.container.getComponentCount() == 2) {
            this.container.remove(1);
        }
        if (tab != null) {
            this.container.add(tab.getComponent());
            tab.show();
        }
    }
}

