/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.workspace;

import echopointng.KeyStrokeListener;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.event.ActionEvent;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.help.HelpDialog;
import org.openvpms.web.component.im.util.IMObjectHelper;
import org.openvpms.web.component.mail.MailContext;
import org.openvpms.web.component.workspace.Heading;
import org.openvpms.web.component.workspace.Workspace;
import org.openvpms.web.echo.event.ActionListener;
import org.openvpms.web.echo.help.HelpContext;

public abstract class AbstractWorkspace<T extends IMObject>
implements Workspace<T> {
    private final String id;
    private final Context context;
    private T object;
    private Component component;
    private PropertyChangeSupport propertyChangeNotifier;
    private MailContext mailContext;
    private HelpContext help;

    public AbstractWorkspace(String id, Context context) {
        this.id = id;
        this.context = context;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getTitleKey() {
        return "workspace." + this.id;
    }

    @Override
    public Component getComponent() {
        if (this.component == null || this.refreshWorkspace()) {
            this.component = this.doLayout();
        }
        return this.component;
    }

    @Override
    public void show() {
    }

    @Override
    public void hide() {
    }

    @Override
    public Component getSummary() {
        return null;
    }

    @Override
    public void setObject(T object) {
        this.object = object;
    }

    @Override
    public T getObject() {
        return this.object;
    }

    @Override
    public boolean canUpdate(String shortName) {
        return false;
    }

    @Override
    public void update(String archetype) {
    }

    @Override
    public void setIMObject(IMObject object) {
        Class<T> type = this.getType();
        if (object != this.getObject()) {
            if (object == null || type.isAssignableFrom(object.getClass())) {
                this.setObject((IMObject)type.cast(object));
            } else {
                throw new IllegalArgumentException("Argument 'object' must be an instance of " + type.getName());
            }
        }
    }

    @Override
    public void update(IMObject object) {
        this.setIMObject(object);
    }

    public Context getContext() {
        return this.context;
    }

    public void setMailContext(MailContext context) {
        this.mailContext = context;
    }

    public MailContext getMailContext() {
        return this.mailContext;
    }

    @Override
    public HelpContext getHelpContext() {
        if (this.help == null) {
            this.help = HelpDialog.getHelpContext(this.getHelpTopic());
        }
        return this.help;
    }

    @Override
    public void preferencesChanged() {
    }

    @Override
    public void addPropertyChangeListener(String name, PropertyChangeListener listener) {
        if (this.propertyChangeNotifier == null) {
            this.propertyChangeNotifier = new PropertyChangeSupport(this);
        }
        this.propertyChangeNotifier.addPropertyChangeListener(name, listener);
    }

    @Override
    public void removePropertyChangeListener(String name, PropertyChangeListener listener) {
        if (this.propertyChangeNotifier != null) {
            this.propertyChangeNotifier.removePropertyChangeListener(name, listener);
        }
    }

    protected void firePropertyChange(String name, Object oldValue, Object newValue) {
        if (this.propertyChangeNotifier != null) {
            this.propertyChangeNotifier.firePropertyChange(name, oldValue, newValue);
        }
    }

    protected abstract Class<T> getType();

    protected Component doLayout() {
        return this.createHeading();
    }

    protected Component createHeading() {
        Component heading = Heading.getHeading(this.id);
        KeyStrokeListener listener = new KeyStrokeListener();
        listener.addKeyCombination(this.getHelpContext().getKeyCode());
        listener.addActionListener((nextapp.echo2.app.event.ActionListener)new ActionListener(){

            public void onAction(ActionEvent event) {
                AbstractWorkspace.this.onHelp();
            }
        });
        heading.add((Component)listener);
        return heading;
    }

    protected boolean refreshWorkspace() {
        return this.getLatest() != this.getObject();
    }

    protected T getLatest() {
        return this.getLatest(this.getObject());
    }

    protected T getLatest(T context) {
        context = IMObjectHelper.reload(context);
        if (!IMObjectHelper.isSame(this.getObject(), context)) {
            if (context != null && !this.canUpdate(context.getArchetype())) {
                return null;
            }
            return context;
        }
        return this.getObject();
    }

    protected void onHelp() {
        this.getHelpContext().show();
    }

    protected String getHelpTopic() {
        return this.id.replace('.', '/');
    }
}

