/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.workspace;

import nextapp.echo2.app.Component;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.im.archetype.Archetypes;
import org.openvpms.web.component.workspace.AbstractViewWorkspace;
import org.openvpms.web.component.workspace.CRUDWindow;
import org.openvpms.web.component.workspace.CRUDWindowListener;
import org.openvpms.web.component.workspace.DefaultCRUDWindow;
import org.openvpms.web.resource.i18n.Messages;

public abstract class AbstractCRUDWorkspace<Parent extends IMObject, Child extends IMObject>
extends AbstractViewWorkspace<Parent> {
    private Archetypes<Child> childArchetypes;
    private CRUDWindow<Child> window;

    public AbstractCRUDWorkspace(String id, Context context, boolean showSelector) {
        this(id, null, null, context, showSelector);
    }

    public AbstractCRUDWorkspace(String id, Archetypes<Parent> archetypes, Archetypes<Child> childArchetypes, Context context) {
        this(id, archetypes, childArchetypes, context, true);
    }

    public AbstractCRUDWorkspace(String id, Archetypes<Parent> archetypes, Archetypes<Child> childArchetypes, Context context, boolean showSelector) {
        super(id, archetypes, context, showSelector);
        this.childArchetypes = childArchetypes;
    }

    protected CRUDWindow<Child> getCRUDWindow() {
        if (this.window == null) {
            CRUDWindow<Child> window = this.createCRUDWindow();
            this.setCRUDWindow(window);
        }
        return this.window;
    }

    protected void setCRUDWindow(CRUDWindow<Child> newWindow) {
        int index;
        Component current;
        Component parent;
        if (newWindow != null) {
            newWindow.setMailContext(this.getMailContext());
        }
        if (this.window != null && (parent = (current = this.window.getComponent()).getParent()) != null && (index = parent.indexOf(current)) != -1) {
            parent.remove(index);
            if (newWindow != null) {
                parent.add(newWindow.getComponent(), index);
            }
        }
        this.window = newWindow;
        if (this.window != null) {
            this.window.setListener(new CRUDWindowListener<Child>(){

                @Override
                public void saved(Child object, boolean isNew) {
                    AbstractCRUDWorkspace.this.onSaved(object, isNew);
                }

                @Override
                public void deleted(Child object) {
                    AbstractCRUDWorkspace.this.onDeleted(object);
                }

                @Override
                public void refresh(Child object) {
                    AbstractCRUDWorkspace.this.onRefresh(object);
                }
            });
        }
    }

    protected CRUDWindow<Child> createCRUDWindow() {
        return new DefaultCRUDWindow<Child>(this.getChildArchetypes(), this.getContext(), this.getHelpContext());
    }

    protected Archetypes<Child> getChildArchetypes() {
        return this.childArchetypes;
    }

    protected void setChildArchetypes(Archetypes<Child> archetypes) {
        this.childArchetypes = archetypes;
    }

    protected void setChildArchetypes(Class<Child> type, String ... shortNames) {
        String key = this.getId() + ".createtype";
        Archetypes<Child> archetypes = Archetypes.create(shortNames, type, Messages.get((String)key));
        this.setChildArchetypes(archetypes);
    }

    @Override
    protected void doLayout(Component container) {
        CRUDWindow<Child> window = this.getCRUDWindow();
        container.add(window.getComponent());
    }

    protected void onSaved(Child object, boolean isNew) {
    }

    protected void onDeleted(Child object) {
    }

    protected void onRefresh(Child object) {
    }
}

