/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.workflow;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import org.openvpms.web.component.workflow.TaskContext;
import org.openvpms.web.component.workflow.TaskProperty;

public class TaskProperties {
    private final Map<String, TaskProperty> properties = new HashMap<String, TaskProperty>();

    public void add(TaskProperty property) {
        this.properties.put(property.getName(), property);
    }

    public void add(String name, Object value) {
        this.add(new Constant(name, value));
    }

    public void add(final String name, final Supplier<Object> supplier) {
        TaskProperty property = new TaskProperty(){

            @Override
            public String getName() {
                return name;
            }

            @Override
            public Object getValue(TaskContext context) {
                return supplier.get();
            }
        };
        this.add(property);
    }

    public TaskProperty get(String name) {
        return this.properties.get(name);
    }

    public Collection<TaskProperty> getProperties() {
        return this.properties.values();
    }

    private static class Constant
    implements TaskProperty {
        private final String name;
        private final Object value;

        public Constant(String name, Object value) {
            this.name = name;
            this.value = value;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public Object getValue(TaskContext context) {
            return this.value;
        }
    }
}

