/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.workflow;

import nextapp.echo2.app.event.WindowPaneListener;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.im.layout.DefaultLayoutContext;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.im.query.Browser;
import org.openvpms.web.component.im.query.BrowserDialog;
import org.openvpms.web.component.im.query.BrowserFactory;
import org.openvpms.web.component.im.query.Query;
import org.openvpms.web.component.im.query.QueryFactory;
import org.openvpms.web.component.workflow.AbstractTask;
import org.openvpms.web.component.workflow.DefaultTaskListener;
import org.openvpms.web.component.workflow.Task;
import org.openvpms.web.component.workflow.TaskContext;
import org.openvpms.web.component.workflow.TaskEvent;
import org.openvpms.web.echo.dialog.PopupDialog;
import org.openvpms.web.echo.dialog.PopupDialogListener;
import org.openvpms.web.echo.help.HelpContext;
import org.openvpms.web.resource.i18n.Messages;

public class SelectIMObjectTask<T extends IMObject>
extends AbstractTask {
    private final String type;
    private final Query<T> query;
    private final Task createTask;
    private final HelpContext help;
    private String title;
    private String message;
    private BrowserDialog<T> dialog;

    public SelectIMObjectTask(String shortName, Context context, HelpContext help) {
        this(shortName, context, null, help);
    }

    public SelectIMObjectTask(String shortName, Context context, Task createTask, HelpContext help) {
        this.query = QueryFactory.create(shortName, context, IMObject.class);
        this.type = SelectIMObjectTask.getType(this.query.getShortNames());
        this.createTask = createTask;
        this.help = help;
    }

    public SelectIMObjectTask(Query<T> query, HelpContext help) {
        this(SelectIMObjectTask.getType(query.getShortNames()), query, null, help);
    }

    public SelectIMObjectTask(Query<T> query, Task createTask, HelpContext help) {
        this(SelectIMObjectTask.getType(query.getShortNames()), query, createTask, help);
    }

    public SelectIMObjectTask(String type, Query<T> query, Task createTask, HelpContext help) {
        this.type = type;
        this.query = query;
        this.createTask = createTask;
        this.help = help;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public BrowserDialog<T> getBrowserDialog() {
        return this.dialog;
    }

    @Override
    public void start(final TaskContext context) {
        DefaultLayoutContext layout = new DefaultLayoutContext(context, this.help.subtopic("select"));
        Browser<T> browser = this.createBrowser(this.query, layout);
        if (this.title == null) {
            this.title = Messages.format((String)"imobject.select.title", (Object[])new Object[]{this.type});
        }
        String[] buttons = this.isRequired() ? PopupDialog.CANCEL : PopupDialog.SKIP_CANCEL;
        boolean addNew = this.createTask != null;
        this.dialog = new BrowserDialog<T>(this.title, this.message, buttons, browser, addNew, layout.getHelpContext());
        this.dialog.addWindowPaneListener((WindowPaneListener)new PopupDialogListener(){

            protected void onAction(PopupDialog dialog) {
                try {
                    super.onAction(dialog);
                }
                finally {
                    SelectIMObjectTask.this.dialog = null;
                }
            }

            public void onOK() {
                IMObject selected = (IMObject)SelectIMObjectTask.this.dialog.getSelected();
                if (selected != null) {
                    SelectIMObjectTask.this.onSelected(selected, context);
                    SelectIMObjectTask.this.notifyCompleted();
                } else {
                    SelectIMObjectTask.this.notifyCancelled();
                }
            }

            public void onSkip() {
                SelectIMObjectTask.this.notifySkipped();
            }

            public void onCancel() {
                SelectIMObjectTask.this.notifyCancelled();
            }

            public void onAction(String action) {
                if (SelectIMObjectTask.this.dialog.createNew()) {
                    this.onNew();
                } else {
                    SelectIMObjectTask.this.notifyCancelled();
                }
            }

            private void onNew() {
                if (SelectIMObjectTask.this.createTask != null) {
                    SelectIMObjectTask.this.createTask.addTaskListener(new DefaultTaskListener(){

                        @Override
                        public void taskEvent(TaskEvent event) {
                            SelectIMObjectTask.this.notifyEvent(event.getType());
                        }
                    });
                    SelectIMObjectTask.this.start(SelectIMObjectTask.this.createTask, context);
                } else {
                    SelectIMObjectTask.this.notifyCancelled();
                }
            }
        });
        this.dialog.show();
    }

    protected void onSelected(T selected, TaskContext context) {
        context.addObject((IMObject)selected);
    }

    protected Browser<T> createBrowser(Query<T> query, LayoutContext layout) {
        return BrowserFactory.create(query, layout);
    }
}

