/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.workflow;

import org.openvpms.component.business.service.archetype.helper.DescriptorHelper;
import org.openvpms.component.business.service.archetype.rule.IArchetypeRuleService;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.web.component.app.ContextException;
import org.openvpms.web.component.workflow.SynchronousTask;
import org.openvpms.web.component.workflow.TaskContext;
import org.openvpms.web.echo.dialog.ErrorDialog;
import org.openvpms.web.resource.i18n.Messages;
import org.openvpms.web.system.ServiceHelper;

public class ReloadTask
extends SynchronousTask {
    private final String shortName;

    public ReloadTask(String shortName) {
        this.shortName = shortName;
    }

    @Override
    public void execute(TaskContext context) {
        IMObject object = context.getObject(this.shortName);
        if (object == null) {
            throw new ContextException(ContextException.ErrorCode.NoObject, this.shortName);
        }
        IArchetypeRuleService service = ServiceHelper.getArchetypeService();
        object = service.get(object.getObjectReference());
        if (object == null) {
            String displayName = DescriptorHelper.getDisplayName((String)this.shortName, (ArchetypeService)service);
            ErrorDialog.show((String)Messages.format((String)"imobject.noexist", (Object[])new Object[]{displayName}));
            this.notifyCancelled();
        } else {
            context.setObject(this.shortName, object);
        }
    }
}

