/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.workflow;

import org.openvpms.component.model.object.IMObject;
import org.openvpms.web.component.app.LocalContext;
import org.openvpms.web.component.workflow.AbstractTask;
import org.openvpms.web.component.workflow.DefaultTaskContext;
import org.openvpms.web.component.workflow.DefaultTaskListener;
import org.openvpms.web.component.workflow.Task;
import org.openvpms.web.component.workflow.TaskContext;
import org.openvpms.web.component.workflow.TaskEvent;

public class LocalTask
extends AbstractTask {
    private final Task task;
    private final String[] keys;

    public LocalTask(Task task, String ... keys) {
        this.task = task;
        this.keys = keys;
    }

    @Override
    public void start(final TaskContext context) {
        final LocalContext local = new LocalContext();
        DefaultTaskContext subContext = new DefaultTaskContext(local, context, context.getHelpContext());
        this.task.addTaskListener(new DefaultTaskListener(){

            @Override
            public void taskEvent(TaskEvent event) {
                switch (event.getType()) {
                    case SKIPPED: {
                        LocalTask.this.notifySkipped();
                        break;
                    }
                    case CANCELLED: {
                        LocalTask.this.notifyCancelled();
                        break;
                    }
                    case COMPLETED: {
                        LocalTask.this.onCompleted(local, context);
                    }
                }
            }
        });
        this.task.start(subContext);
    }

    public Task getTask() {
        return this.task;
    }

    private void onCompleted(LocalContext local, TaskContext parent) {
        for (String key : this.keys) {
            IMObject object = local.getObject(key);
            if (object == null) continue;
            parent.setObject(key, object);
        }
        this.notifyCompleted();
    }
}

