/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.workflow;

import org.openvpms.component.exception.OpenVPMSException;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.web.component.im.util.IMObjectCreator;
import org.openvpms.web.component.im.util.IMObjectCreatorListener;
import org.openvpms.web.component.workflow.AbstractTask;
import org.openvpms.web.component.workflow.TaskContext;
import org.openvpms.web.component.workflow.TaskProperties;

public class CreateIMObjectTask
extends AbstractTask {
    private final String[] shortNames;
    private final TaskProperties properties;

    public CreateIMObjectTask(String shortName) {
        this(new String[]{shortName});
    }

    public CreateIMObjectTask(String shortName, TaskProperties properties) {
        this(new String[]{shortName}, properties);
    }

    public CreateIMObjectTask(String[] shortNames) {
        this(shortNames, null);
    }

    public CreateIMObjectTask(String[] shortNames, TaskProperties properties) {
        this.shortNames = shortNames;
        this.properties = properties;
    }

    @Override
    public void start(final TaskContext context) {
        IMObjectCreatorListener listener = new IMObjectCreatorListener(){

            @Override
            public void created(IMObject object) {
                CreateIMObjectTask.this.onCreated(object, context);
            }

            @Override
            public void cancelled() {
                CreateIMObjectTask.this.notifyCancelled();
            }
        };
        IMObjectCreator.create(CreateIMObjectTask.getType(this.shortNames), this.shortNames, listener, context.getHelpContext());
    }

    public String[] getShortNames() {
        return this.shortNames;
    }

    protected void created(IMObject object, TaskContext context) {
        if (this.properties != null) {
            this.populate(object, this.properties, context);
        }
        context.addObject(object);
    }

    private void onCreated(IMObject object, TaskContext context) {
        try {
            this.created(object, context);
            this.notifyCompleted();
        }
        catch (OpenVPMSException exception) {
            this.notifyCancelledOnError(exception);
        }
    }
}

