/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.workflow;

import org.openvpms.web.component.workflow.AbstractConfirmationTask;
import org.openvpms.web.component.workflow.TaskContext;
import org.openvpms.web.echo.dialog.ConfirmationDialog;
import org.openvpms.web.echo.dialog.PopupDialog;
import org.openvpms.web.echo.help.HelpContext;

public class ConfirmationTask
extends AbstractConfirmationTask {
    private final String title;
    private final String message;
    private final Type type;

    public ConfirmationTask(String title, String message, HelpContext help) {
        this(title, message, true, help);
    }

    public ConfirmationTask(String title, String message, boolean displayNo, HelpContext help) {
        this(title, message, displayNo ? Type.YES_NO_CANCEL : Type.OK_CANCEL, help);
    }

    public ConfirmationTask(String title, String message, Type type, HelpContext help) {
        super(help);
        this.title = title;
        this.message = message;
        this.type = type;
    }

    @Override
    protected ConfirmationDialog createConfirmationDialog(TaskContext context, HelpContext help) {
        String[] buttons = this.type == Type.YES_NO_CANCEL ? PopupDialog.YES_NO_CANCEL : (this.type == Type.YES_NO ? PopupDialog.YES_NO : PopupDialog.OK_CANCEL);
        return this.createConfirmationDialog(this.title, this.message, buttons, help);
    }

    protected ConfirmationDialog createConfirmationDialog(String title, String message, String[] buttons, HelpContext help) {
        return new ConfirmationDialog(title, message, buttons, help);
    }

    public static enum Type {
        YES_NO_CANCEL,
        YES_NO,
        OK_CANCEL;

    }
}

