/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.subscription;

import java.io.IOException;
import java.io.InputStream;
import java.security.GeneralSecurityException;
import java.util.Date;
import org.apache.commons.text.StringEscapeUtils;
import org.joda.time.DateTime;
import org.joda.time.Days;
import org.joda.time.ReadableInstant;
import org.openvpms.archetype.rules.doc.DefaultDocumentHandler;
import org.openvpms.archetype.rules.practice.PracticeRules;
import org.openvpms.archetype.rules.util.DateRules;
import org.openvpms.component.business.domain.im.document.Document;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.business.service.archetype.rule.IArchetypeRuleService;
import org.openvpms.component.model.act.DocumentAct;
import org.openvpms.component.model.act.Participation;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.component.system.common.query.ArchetypeQuery;
import org.openvpms.component.system.common.query.IArchetypeQuery;
import org.openvpms.component.system.common.query.IConstraint;
import org.openvpms.component.system.common.query.IMObjectQueryIterator;
import org.openvpms.component.system.common.query.ObjectRefNodeConstraint;
import org.openvpms.subscription.core.Subscription;
import org.openvpms.subscription.core.SubscriptionFactory;
import org.openvpms.web.resource.i18n.Messages;
import org.openvpms.web.resource.i18n.format.DateFormatter;
import org.openvpms.web.system.ServiceHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubscriptionHelper {
    private static final Logger log = LoggerFactory.getLogger((String)SubscriptionHelper.class.getName());

    public static String formatSubscription() {
        Subscription subscription = SubscriptionHelper.getSubscription();
        return SubscriptionHelper.formatSubscription(subscription);
    }

    public static String formatSubscription(Subscription subscription) {
        String organisation = subscription != null ? subscription.getOrganisationName() : null;
        String name = subscription != null ? subscription.getSubscriberName() : null;
        Date expiryDate = subscription != null ? subscription.getExpiryDate() : null;
        return SubscriptionHelper.formatSubscription(organisation, name, expiryDate, new Date());
    }

    public static Subscription getSubscription() {
        Subscription result = null;
        try {
            IArchetypeRuleService service = ServiceHelper.getArchetypeService();
            Party practice = new PracticeRules((ArchetypeService)service, null).getPractice();
            if (practice != null) {
                DocumentAct act = SubscriptionHelper.getSubscriptionAct(practice, (IArchetypeService)service);
                result = SubscriptionHelper.getSubscription(act, (IArchetypeService)service);
            }
        }
        catch (Throwable exception) {
            log.error(exception.getMessage(), exception);
        }
        return result;
    }

    public static boolean isExpiring(Subscription subscription) {
        return subscription != null && SubscriptionHelper.isExpiring(subscription.getExpiryDate(), new Date());
    }

    public static boolean isExpired(Subscription subscription) {
        return subscription != null && SubscriptionHelper.isExpired(subscription.getExpiryDate(), new Date());
    }

    public static Subscription getSubscription(DocumentAct act, IArchetypeService service) throws IOException, GeneralSecurityException {
        Document document;
        Subscription result = null;
        if (act != null && act.getDocument() != null && (document = (Document)service.get(act.getDocument(), Document.class)) != null) {
            DefaultDocumentHandler documentHandler = new DefaultDocumentHandler((ArchetypeService)service);
            InputStream content = documentHandler.getContent((org.openvpms.component.model.document.Document)document);
            result = SubscriptionFactory.create((InputStream)content);
        }
        return result;
    }

    public static Participation getSubscriptionParticipation(Party practice, IArchetypeService service) {
        ArchetypeQuery query = new ArchetypeQuery("participation.subscription", true, true);
        query.add((IConstraint)new ObjectRefNodeConstraint("entity", practice.getObjectReference()));
        query.setMaxResults(1);
        IMObjectQueryIterator iterator = new IMObjectQueryIterator(service, (IArchetypeQuery)query);
        return iterator.hasNext() ? (Participation)iterator.next() : null;
    }

    static String formatSubscription(String organisation, String name, Date expiryDate, Date now) {
        String result = null;
        if (organisation != null || name != null) {
            String user = organisation;
            if (user == null) {
                user = name;
            }
            user = StringEscapeUtils.escapeHtml4((String)user);
            if (expiryDate != null) {
                String date = DateFormatter.getFullDateFormat().format(expiryDate);
                date = StringEscapeUtils.escapeHtml4((String)date);
                result = SubscriptionHelper.isExpired(expiryDate, now) ? Messages.format((String)"subscription.summary.expired", (Object[])new Object[]{user, date}) : (SubscriptionHelper.isExpiring(expiryDate, now) ? Messages.format((String)"subscription.summary.expiring", (Object[])new Object[]{user, date}) : Messages.format((String)"subscription.summary.active", (Object[])new Object[]{user, date}));
            }
        }
        if (result == null) {
            result = Messages.get((String)"subscription.summary.nosubscription");
        }
        return result;
    }

    private static boolean isExpiring(Date expiryDate, Date now) {
        return expiryDate != null && Days.daysBetween((ReadableInstant)new DateTime((Object)now), (ReadableInstant)new DateTime((Object)expiryDate)).getDays() <= 21;
    }

    private static boolean isExpired(Date expiryDate, Date now) {
        return expiryDate != null && DateRules.compareDates((Date)expiryDate, (Date)now) < 0;
    }

    private static DocumentAct getSubscriptionAct(Party practice, IArchetypeService service) {
        DocumentAct result = null;
        Participation participation = SubscriptionHelper.getSubscriptionParticipation(practice, service);
        if (participation != null) {
            result = (DocumentAct)SubscriptionHelper.getObject(participation.getAct(), service);
        }
        return result;
    }

    private static IMObject getObject(Reference ref, IArchetypeService service) {
        return ref != null ? service.get(ref) : null;
    }
}

