/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.property;

import java.math.BigDecimal;
import org.apache.commons.lang3.StringUtils;
import org.openvpms.archetype.rules.math.MathRules;
import org.openvpms.component.system.common.jxpath.OpenVPMSTypeConverter;
import org.openvpms.web.component.property.AbstractPropertyTransformer;
import org.openvpms.web.component.property.Property;
import org.openvpms.web.component.property.PropertyException;
import org.openvpms.web.resource.i18n.Messages;

public class NumericPropertyTransformer
extends AbstractPropertyTransformer {
    private final boolean positive;
    private final int scale;
    private static final OpenVPMSTypeConverter CONVERTER = new OpenVPMSTypeConverter();

    public NumericPropertyTransformer(Property property) {
        this(property, false);
    }

    public NumericPropertyTransformer(Property property, boolean positive) {
        this(property, positive, 2);
    }

    public NumericPropertyTransformer(Property property, boolean positive, int scale) {
        super(property);
        this.positive = positive;
        this.scale = scale;
    }

    @Override
    public Object apply(Object object) {
        Object result;
        boolean empty;
        Property property = this.getProperty();
        boolean bl = empty = object == null || object instanceof String && StringUtils.isEmpty((CharSequence)object.toString());
        if (empty) {
            if (property.isRequired()) {
                String msg = Messages.format((String)"property.error.required", (Object[])new Object[]{property.getDisplayName()});
                throw new PropertyException(property, msg);
            }
            result = null;
        } else {
            result = this.convert(object, property);
            this.validate(result, property);
        }
        return result;
    }

    protected Object convert(Object object, Property property) {
        Object result;
        try {
            Class<?> type = property.getType();
            result = CONVERTER.convert(object, type);
            if (result instanceof BigDecimal) {
                result = MathRules.round((BigDecimal)((BigDecimal)result), (int)this.scale);
            }
        }
        catch (Throwable exception) {
            String message = Messages.format((String)"property.error.invalidnumeric", (Object[])new Object[]{property.getDisplayName()});
            throw new PropertyException(property, message, exception);
        }
        return result;
    }

    protected void validate(Object object, Property property) {
        if (this.positive && object instanceof Number && ((Number)object).doubleValue() < 0.0) {
            String msg = Messages.format((String)"property.error.positive", (Object[])new Object[]{property.getDisplayName()});
            throw new PropertyException(property, msg);
        }
    }
}

