/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.property;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import org.openvpms.web.component.property.AbstractPropertySet;
import org.openvpms.web.component.property.MutableProperty;
import org.openvpms.web.component.property.Property;
import org.openvpms.web.component.property.PropertySet;
import org.openvpms.web.component.property.ReadOnlyProperty;
import org.openvpms.web.component.property.RequiredProperty;

public class MutablePropertySet
extends AbstractPropertySet {
    private final Map<String, Property> properties = new LinkedHashMap<String, Property>();
    private final PropertySet set;

    public MutablePropertySet(PropertySet set) {
        this.set = set;
        for (Property property : set.getProperties()) {
            this.properties.put(property.getName(), property);
        }
    }

    @Override
    public Property get(String name) {
        return this.properties.get(name);
    }

    @Override
    public Collection<Property> getProperties() {
        return this.properties.values();
    }

    @Override
    public void updateDerivedProperties() {
        this.set.updateDerivedProperties();
    }

    public Property setRequired(String name) {
        Property property = this.get(name);
        if (property != null) {
            if (property instanceof MutableProperty) {
                ((MutableProperty)property).setRequired(true);
            } else {
                property = new RequiredProperty(property);
                this.properties.put(name, property);
            }
        }
        return property;
    }

    public Property setReadOnly(String name) {
        Property property = this.get(name);
        if (property != null) {
            if (property instanceof MutableProperty) {
                ((MutableProperty)property).setReadOnly(true);
            } else {
                property = new ReadOnlyProperty(property);
                this.properties.put(name, property);
            }
        }
        return property;
    }

    public Property setHidden(String name) {
        Property property = this.get(name);
        if (property != null) {
            MutableProperty mutable;
            if (property instanceof MutableProperty) {
                mutable = (MutableProperty)property;
            } else {
                mutable = new MutableProperty(property);
                this.properties.put(name, mutable);
            }
            mutable.setHidden(true);
            property = mutable;
        }
        return property;
    }
}

