/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.property;

import org.apache.commons.lang3.mutable.MutableBoolean;
import org.apache.commons.lang3.mutable.MutableInt;
import org.openvpms.web.component.property.DelegatingProperty;
import org.openvpms.web.component.property.Modifiable;
import org.openvpms.web.component.property.Property;
import org.openvpms.web.component.property.Validator;
import org.openvpms.web.resource.i18n.Messages;

public class MutableProperty
extends DelegatingProperty {
    private MutableBoolean readOnly;
    private MutableBoolean hidden;
    private MutableInt minCardinality;

    public MutableProperty(Property property) {
        super(property);
    }

    public boolean setReadOnly(boolean readOnly) {
        boolean changed = false;
        if (this.isReadOnly() != readOnly) {
            this.readOnly = new MutableBoolean(readOnly);
            changed = true;
        }
        return changed;
    }

    @Override
    public boolean isReadOnly() {
        return this.readOnly != null ? this.readOnly.booleanValue() : super.isReadOnly();
    }

    public boolean setHidden(boolean hidden) {
        boolean changed = false;
        if (this.isHidden() != hidden) {
            this.hidden = new MutableBoolean(hidden);
            changed = true;
        }
        return changed;
    }

    @Override
    public boolean isHidden() {
        return this.hidden != null ? this.hidden.booleanValue() : super.isHidden();
    }

    public boolean setRequired(boolean required) {
        boolean changed = false;
        if (this.isRequired() != required) {
            this.minCardinality = required ? new MutableInt(1) : null;
            changed = true;
        }
        return changed;
    }

    @Override
    public boolean isRequired() {
        return this.getMinCardinality() > 0;
    }

    @Override
    public int getMinCardinality() {
        return this.minCardinality != null ? this.minCardinality.intValue() : super.getMinCardinality();
    }

    public boolean setEditable(boolean required) {
        boolean changed = this.setRequired(required);
        changed |= this.setReadOnly(false);
        return changed |= this.setHidden(false);
    }

    public boolean setViewable() {
        boolean changed = this.setReadOnly(true);
        return changed |= this.setHidden(false);
    }

    public boolean setUnsupported() {
        boolean changed = this.setHidden(true);
        changed |= this.setReadOnly(false);
        return changed |= this.setReadOnly(true);
    }

    @Override
    public boolean validate(Validator validator) {
        if (super.validate(validator) && this.isRequired() && this.getValue() == null) {
            validator.add((Modifiable)this, Messages.format((String)"property.error.required", (Object[])new Object[]{this.getDisplayName()}));
        }
        return validator.isValid();
    }
}

