/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.property;

import java.math.BigDecimal;
import java.math.BigInteger;
import org.openvpms.archetype.rules.math.MathRules;
import org.openvpms.component.business.domain.im.datatypes.quantity.Money;
import org.openvpms.web.component.property.NumericPropertyTransformer;
import org.openvpms.web.component.property.Property;
import org.openvpms.web.component.property.PropertyException;
import org.openvpms.web.resource.i18n.Messages;

public class MoneyPropertyTransformer
extends NumericPropertyTransformer {
    public MoneyPropertyTransformer(Property property) {
        super(property);
    }

    @Override
    protected Object convert(Object object, Property property) {
        BigDecimal result;
        block7: {
            try {
                if (object instanceof String) {
                    result = new BigDecimal((String)object);
                    break block7;
                }
                if (object instanceof BigDecimal) {
                    result = new BigDecimal(object.toString());
                    break block7;
                }
                if (object instanceof BigInteger) {
                    result = new BigDecimal((BigInteger)object);
                    break block7;
                }
                if (object instanceof Short || object instanceof Integer || object instanceof Long) {
                    result = new BigDecimal(((Number)object).longValue());
                    break block7;
                }
                if (object instanceof Float || object instanceof Double) {
                    result = BigDecimal.valueOf(((Number)object).doubleValue());
                    break block7;
                }
                throw this.getException(null);
            }
            catch (Throwable exception) {
                throw this.getException(exception);
            }
        }
        return new Money(MathRules.round((BigDecimal)result));
    }

    private PropertyException getException(Throwable cause) {
        String message = Messages.format((String)"property.error.invalidnumeric", (Object[])new Object[]{this.getProperty().getDisplayName()});
        return new PropertyException(this.getProperty(), message, cause);
    }
}

