/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.property;

import echopointng.DateField;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.Extent;
import org.openvpms.web.component.bound.BoundCheckBox;
import org.openvpms.web.component.bound.BoundDateFieldFactory;
import org.openvpms.web.component.bound.BoundTextComponentFactory;
import org.openvpms.web.component.bound.BoundTextField;
import org.openvpms.web.component.im.view.Hint;
import org.openvpms.web.component.property.Property;
import org.openvpms.web.component.property.PropertyComponentFactory;
import org.openvpms.web.echo.factory.ComponentFactory;
import org.openvpms.web.echo.text.PasswordField;
import org.openvpms.web.echo.text.TextArea;
import org.openvpms.web.echo.text.TextField;
import org.openvpms.web.echo.util.StyleSheetHelper;

public abstract class AbstractPropertyComponentFactory
implements PropertyComponentFactory {
    private final String style;
    private final int numericLength;

    public AbstractPropertyComponentFactory(String style) {
        this.style = style;
        this.numericLength = StyleSheetHelper.getNumericLength();
    }

    @Override
    public Component create(Property property) {
        return this.create(property, null);
    }

    @Override
    public Component create(Property property, Hint hint) {
        Component result = null;
        if (property.isBoolean()) {
            result = this.createBoolean(property);
        } else if (property.isString()) {
            result = property.isPassword() ? this.createPassword(property) : this.createString(property, hint);
        } else if (property.isNumeric()) {
            result = this.createNumeric(property);
        } else if (property.isDate()) {
            result = this.createDate(property);
        }
        return result;
    }

    protected Component createBoolean(Property property) {
        BoundCheckBox result = new BoundCheckBox(property);
        ComponentFactory.setStyle((Component)result, (String)this.getStyle());
        return result;
    }

    protected Component createString(Property property, Hint hint) {
        Object result;
        int maxDisplayLength = 50;
        int length = property.getMaxLength();
        int maxColumns = Math.min(length, maxDisplayLength);
        if (hint == null || hint.useDefaultWidth() && hint.useDefaultHeight()) {
            result = this.createString(property, maxColumns);
        } else {
            Extent width = hint.getWidth();
            Extent height = hint.getHeight();
            if (hint.useDefaultHeight() || hint.singleRow()) {
                if (width == null) {
                    width = new Extent(maxDisplayLength, 128);
                }
                BoundTextField component = new BoundTextField(property);
                component.setWidth(width);
                result = component;
            } else {
                TextArea textArea = BoundTextComponentFactory.createTextArea(property);
                textArea.setWidth(width);
                textArea.setHeight(height);
                result = textArea;
            }
            ComponentFactory.setStyle((Component)result, (String)this.getStyle());
        }
        return result;
    }

    protected Component createString(Property property, int columns) {
        Object result = property.getMaxLength() > 255 ? (property.getMaxLength() < 500 ? BoundTextComponentFactory.createTextArea(property, columns, 5) : BoundTextComponentFactory.createTextArea(property, 80, 15)) : BoundTextComponentFactory.create(property, columns);
        ComponentFactory.setStyle((Component)result, (String)this.getStyle());
        return result;
    }

    protected Component createNumeric(Property property) {
        TextField result = BoundTextComponentFactory.createNumeric(property, this.numericLength);
        ComponentFactory.setStyle((Component)result, (String)this.getStyle());
        return result;
    }

    protected Component createDate(Property property) {
        DateField result = BoundDateFieldFactory.create(property);
        ComponentFactory.setStyle((Component)result, (String)this.getStyle());
        ComponentFactory.setStyle((Component)result.getTextField(), (String)this.getStyle());
        return result;
    }

    protected Component createPassword(Property property) {
        PasswordField result = BoundTextComponentFactory.createPassword(property);
        ComponentFactory.setStyle((Component)result, (String)this.getStyle());
        return result;
    }

    protected String getStyle() {
        return this.style;
    }
}

