/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.processor;

import echopointng.ProgressBar;
import java.util.Iterator;
import nextapp.echo2.app.ApplicationInstance;
import nextapp.echo2.app.Color;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.TaskQueueHandle;
import nextapp.echo2.webcontainer.ContainerContext;
import org.openvpms.archetype.component.processor.AbstractAsynchronousBatchProcessor;
import org.openvpms.component.exception.OpenVPMSException;
import org.openvpms.web.component.processor.BatchProcessorComponent;
import org.openvpms.web.component.processor.RetryListener;
import org.openvpms.web.echo.event.Vetoable;
import org.openvpms.web.echo.servlet.SessionMonitor;
import org.openvpms.web.system.ServiceHelper;

public abstract class ProgressBarProcessor<T>
extends AbstractAsynchronousBatchProcessor<T>
implements BatchProcessorComponent {
    private final String title;
    private final SessionMonitor monitor;
    private final ProgressBar bar = new ProgressBar();
    private int step;
    private TaskQueueHandle taskQueue;
    private long lastRefresh = 0L;
    private RetryListener<T> retryListener;
    private boolean completed = false;
    private static final long REFRESH_INTERVAL = 2000L;

    public ProgressBarProcessor(Iterable<T> items, int size, String title) {
        this(title);
        this.setItems(items, size);
    }

    public ProgressBarProcessor(String title) {
        this.bar.setCompletedColor(Color.GREEN);
        this.bar.setNumberOfBlocks(20);
        this.title = title;
        this.monitor = ServiceHelper.getBean(SessionMonitor.class);
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public Component getComponent() {
        return this.bar;
    }

    public int getCount() {
        return this.bar.getMaximum();
    }

    public void setRetryListener(RetryListener<T> listener) {
        this.retryListener = listener;
    }

    public void cancel() {
        this.setSuspend(true);
        this.processingCompleted();
    }

    public void process() {
        this.monitor.active();
        this.completed = false;
        super.process();
    }

    protected void setItems(Iterable<T> items, int size) {
        this.setItems(items.iterator(), size);
    }

    protected void setItems(Iterator<T> items, int size) {
        this.setIterator(items);
        this.bar.setMaximum(size);
        this.step = size / 10;
        if (this.step == 0) {
            this.step = 1;
        }
    }

    protected void processingCompleted() {
        if (!this.completed) {
            this.completed = true;
            this.removeTaskQueue();
            this.bar.setValue(this.getProcessed());
            super.processingCompleted();
        }
    }

    protected void processingError(Throwable exception) {
        this.removeTaskQueue();
        super.processingError(exception);
    }

    protected void processCompleted(T object) {
        this.incProcessed(object);
        long time = System.currentTimeMillis();
        int processed = this.getProcessed();
        if (processed > this.bar.getMaximum()) {
            this.bar.setMaximum(processed);
        }
        if (processed % this.step == 0) {
            this.bar.setValue(processed);
        }
        if (!(this.isSuspended() || this.lastRefresh != 0L && time - this.lastRefresh <= 2000L)) {
            this.setSuspend(true);
            ApplicationInstance app = ApplicationInstance.getActive();
            app.enqueueTask(this.getTaskQueue(), new Runnable(){

                @Override
                public void run() {
                    ProgressBarProcessor.this.process();
                }
            });
            this.lastRefresh = time;
        }
    }

    protected void processFailed(final T object, String message, Throwable cause) {
        this.setSuspend(true);
        if (this.retryListener != null) {
            Vetoable veto = new Vetoable(){

                public void veto(boolean veto) {
                    if (!veto) {
                        ProgressBarProcessor.this.retry(object);
                    }
                }
            };
            this.retryListener.retry(object, veto, message);
        } else {
            this.notifyError(cause);
        }
    }

    protected void retry(T object) {
        try {
            this.setSuspend(false);
            this.process(object);
            if (!this.isSuspended()) {
                this.process();
            }
        }
        catch (OpenVPMSException exception) {
            this.processFailed(object, exception.getMessage(), exception);
        }
    }

    protected ProgressBar getProgressBar() {
        return this.bar;
    }

    private TaskQueueHandle getTaskQueue() {
        if (this.taskQueue == null) {
            ApplicationInstance app = ApplicationInstance.getActive();
            this.taskQueue = app.createTaskQueue();
            ContainerContext context = (ContainerContext)app.getContextProperty(ContainerContext.CONTEXT_PROPERTY_NAME);
            if (context != null) {
                context.setTaskQueueCallbackInterval(this.taskQueue, 500);
            }
        }
        return this.taskQueue;
    }

    private void removeTaskQueue() {
        if (this.taskQueue != null) {
            ApplicationInstance app = ApplicationInstance.getActive();
            app.removeTaskQueue(this.taskQueue);
            this.taskQueue = null;
        }
    }
}

