/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.print;

import nextapp.echo2.app.Component;
import org.openvpms.archetype.rules.doc.PrinterReference;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.im.view.TableComponentFactory;
import org.openvpms.web.component.property.Property;
import org.openvpms.web.echo.factory.LabelFactory;
import org.openvpms.web.echo.factory.TextComponentFactory;
import org.openvpms.web.echo.text.TextField;

public class PrinterViewer {
    private final Component component;

    public PrinterViewer(Property property, LayoutContext context) {
        this(property.getString(), context);
    }

    public PrinterViewer(String printer, LayoutContext context) {
        PrinterReference reference = PrinterReference.fromString((String)printer);
        StringBuilder builder = new StringBuilder();
        if (reference != null) {
            if (reference.getArchetype() != null && reference.getServiceName() != null) {
                builder.append(reference.getServiceName());
                builder.append(": ");
            }
            builder.append(reference.getName());
        }
        if (context.getComponentFactory() instanceof TableComponentFactory) {
            this.component = LabelFactory.text((String)builder.toString());
        } else {
            TextField field = TextComponentFactory.create((int)50);
            field.setStyleName(context.getComponentFactory().getReadOnlyStyle());
            field.setText(builder.toString());
            this.component = field;
        }
    }

    public Component getComponent() {
        return this.component;
    }
}

