/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.print;

import nextapp.echo2.app.event.WindowPaneEvent;
import nextapp.echo2.app.event.WindowPaneListener;
import org.openvpms.archetype.rules.doc.PrinterReference;
import org.openvpms.component.model.document.Document;
import org.openvpms.print.impl.exception.PrintNotSupported;
import org.openvpms.print.locator.DocumentPrinterServiceLocator;
import org.openvpms.print.service.DocumentPrinter;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.im.doc.DocumentJobManager;
import org.openvpms.web.component.im.layout.DefaultLayoutContext;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.job.Job;
import org.openvpms.web.component.job.JobBuilder;
import org.openvpms.web.component.mail.MailContext;
import org.openvpms.web.component.mail.MailDialog;
import org.openvpms.web.component.mail.MailDialogFactory;
import org.openvpms.web.component.mail.MailEditor;
import org.openvpms.web.component.print.PrintDialog;
import org.openvpms.web.component.print.Printer;
import org.openvpms.web.component.print.PrinterListener;
import org.openvpms.web.component.util.ErrorHelper;
import org.openvpms.web.echo.dialog.ConfirmationDialog;
import org.openvpms.web.echo.dialog.ConfirmationDialogBuilder;
import org.openvpms.web.echo.event.VetoListener;
import org.openvpms.web.echo.event.Vetoable;
import org.openvpms.web.echo.help.HelpContext;
import org.openvpms.web.echo.servlet.DownloadServlet;
import org.openvpms.web.resource.i18n.Messages;
import org.openvpms.web.system.ServiceHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InteractivePrinter
implements Printer {
    private final Printer printer;
    private final String title;
    private final boolean skip;
    private final Context context;
    private final HelpContext help;
    private final DocumentJobManager manager;
    private PrinterListener listener;
    private VetoListener<Vetoable> cancelListener;
    private boolean interactive;
    private MailContext mailContext;
    private PrintDialog dialog;
    private static final Logger log = LoggerFactory.getLogger(InteractivePrinter.class);

    public InteractivePrinter(Printer printer, Context context, HelpContext help) {
        this(printer, false, context, help);
    }

    public InteractivePrinter(Printer printer, boolean skip, Context context, HelpContext help) {
        this(null, printer, skip, context, help);
    }

    public InteractivePrinter(String title, Printer printer, Context context, HelpContext help) {
        this(title, printer, false, context, help);
    }

    public InteractivePrinter(String title, Printer printer, boolean skip, Context context, HelpContext help) {
        this.title = title;
        this.printer = printer;
        this.skip = skip;
        this.context = context;
        this.help = help;
        this.interactive = printer.getInteractive();
        this.manager = ServiceHelper.getBean(DocumentJobManager.class);
    }

    @Override
    public void print() {
        DocumentPrinter printer = this.getDefaultPrinter();
        this.print(printer);
    }

    @Override
    public void print(DocumentPrinter printer) {
        if (this.interactive || printer == null) {
            this.printInteractive(printer);
        } else {
            this.doPrint(printer);
        }
    }

    @Override
    public void print(PrinterReference reference) {
        DocumentPrinter printer = null;
        if (reference != null && (printer = this.getPrinterLocator().getPrinter(reference.getArchetype(), reference.getId())) == null) {
            log.warn("Printer not found: " + reference);
        }
        if (this.interactive || printer == null) {
            this.printInteractive(printer);
        } else {
            this.doPrint(printer);
        }
    }

    @Override
    public DocumentPrinter getDefaultPrinter() {
        return this.printer.getDefaultPrinter();
    }

    @Override
    public Document getDocument() {
        return this.getDocument("application/pdf", false);
    }

    @Override
    public Document getDocument(String mimeType, boolean email) {
        return this.printer.getDocument(mimeType, email);
    }

    public void setInteractive(boolean interactive) {
        this.interactive = interactive;
    }

    @Override
    public boolean getInteractive() {
        return this.interactive;
    }

    @Override
    public void setCopies(int copies) {
        this.printer.setCopies(copies);
    }

    @Override
    public int getCopies() {
        return this.printer.getCopies();
    }

    @Override
    public String getDisplayName() {
        return this.printer.getDisplayName();
    }

    @Override
    public DocumentPrinterServiceLocator getPrinterLocator() {
        return this.printer.getPrinterLocator();
    }

    public void setListener(PrinterListener listener) {
        this.listener = listener;
    }

    public void setCancelListener(VetoListener<Vetoable> listener) {
        this.cancelListener = listener;
    }

    public void setMailContext(MailContext context) {
        this.mailContext = context;
    }

    public MailContext getMailContext() {
        return this.mailContext;
    }

    public PrintDialog getPrintDialog() {
        return this.dialog;
    }

    protected Printer getPrinter() {
        return this.printer;
    }

    protected String getTitle() {
        return this.title;
    }

    protected Context getContext() {
        return this.context;
    }

    protected HelpContext getHelpContext() {
        return this.help;
    }

    protected PrintDialog createDialog() {
        String title = this.getTitle();
        if (title == null) {
            title = Messages.get((String)"printdialog.title");
        }
        boolean mail = this.mailContext != null;
        return new PrintDialog(title, true, mail, this.skip, this.context.getLocation(), this.help){

            @Override
            protected void onPreview() {
                InteractivePrinter.this.preview();
            }

            @Override
            protected void onMail() {
                InteractivePrinter.this.mail(this);
            }
        };
    }

    protected void printInteractive(DocumentPrinter printer) {
        this.dialog = this.createDialog();
        if (printer == null) {
            printer = this.getDefaultPrinter();
        }
        this.dialog.setDefaultPrinter(printer);
        this.dialog.setCopies(this.printer.getCopies());
        this.dialog.setCancelListener(this.cancelListener);
        this.dialog.addWindowPaneListener((WindowPaneListener)new org.openvpms.web.echo.event.WindowPaneListener(){

            public void onClose(WindowPaneEvent event) {
                try {
                    InteractivePrinter.this.handleAction(InteractivePrinter.this.dialog);
                }
                finally {
                    InteractivePrinter.this.dialog = null;
                }
            }
        });
        this.dialog.show();
    }

    protected void doPrint(DocumentPrinter printer) {
        Job job = this.newJob().run(() -> this.printer.print(printer)).completed(() -> this.printed(printer)).cancelled(this::cancelled).failed(this::printFailed).build();
        this.manager.runInteractive(job, Messages.get((String)"document.print.title"), Messages.get((String)"document.print.cancel"));
    }

    protected void handleAction(PrintDialog dialog) {
        String action = dialog.getAction();
        if ("ok".equals(action)) {
            PrinterReference reference = dialog.getPrinter();
            DocumentPrinter selected = this.getPrinter(reference);
            if (selected == null) {
                this.download();
            } else {
                this.printer.setCopies(dialog.getCopies());
                this.doPrint(selected);
            }
        } else if ("skip".equals(action)) {
            this.skipped();
        } else if ("send".equals(action)) {
            this.mailed();
        } else {
            this.cancelled();
        }
    }

    protected void preview() {
        this.manager.preview(this, this.getContext().getUser());
    }

    protected void mail(PrintDialog parent) {
        Job<Document> job = JobBuilder.newJob(this.getDisplayName(), this.getContext().getUser()).get(() -> this.getDocument("application/pdf", true)).completed(document -> this.mail((Document)document, parent)).failed(this::failed).build();
        this.manager.runInteractive(job, Messages.get((String)"document.mail.title"), Messages.get((String)"document.mail.cancel"));
    }

    protected void printed(DocumentPrinter printer) {
        if (this.listener != null) {
            this.listener.printed(printer);
        }
    }

    protected void printFailed(Throwable exception) {
        if (exception instanceof PrintNotSupported) {
            ((ConfirmationDialogBuilder)((ConfirmationDialogBuilder)((ConfirmationDialogBuilder)((ConfirmationDialogBuilder)((ConfirmationDialogBuilder)ConfirmationDialog.newDialog().title(Messages.get((String)"document.print.title"))).message(Messages.get((String)"document.print.unsupported"))).yesNo()).yes(this::download)).no(this::cancelled)).show();
        } else {
            this.failed(exception);
        }
    }

    protected void cancelled() {
        if (this.listener != null) {
            this.listener.cancelled();
        }
    }

    protected void skipped() {
        if (this.listener != null) {
            this.listener.skipped();
        }
    }

    protected void mailed() {
        if (this.listener != null) {
            this.listener.skipped();
        }
    }

    protected void failed(Throwable exception) {
        if (this.listener != null) {
            this.listener.failed(exception);
        } else {
            ErrorHelper.show(exception);
        }
    }

    protected void mail(Document document, final PrintDialog parent) {
        DefaultLayoutContext layoutContext = new DefaultLayoutContext(this.context, this.help.subtopic("email"));
        final MailDialog dialog = this.createMailDialog(document, this.mailContext, layoutContext);
        dialog.addWindowPaneListener((WindowPaneListener)new org.openvpms.web.echo.event.WindowPaneListener(){

            public void onClose(WindowPaneEvent event) {
                if ("send".equals(dialog.getAction())) {
                    parent.close("send");
                }
            }
        });
        this.show(dialog);
    }

    protected MailDialog createMailDialog(Document document, MailContext mailContext, LayoutContext layoutContext) {
        MailDialog dialog = ServiceHelper.getBean(MailDialogFactory.class).create(mailContext, layoutContext);
        MailEditor editor = dialog.getMailEditor();
        editor.setSubject(this.getDisplayName());
        editor.addAttachment(document);
        return dialog;
    }

    protected void show(MailDialog dialog) {
        dialog.show();
    }

    protected DocumentJobManager getJobManager() {
        return this.manager;
    }

    private void download() {
        JobBuilder<Document> builder = this.newJob();
        Job<Document> job = builder.get(this::getDocument).completed(document -> {
            DownloadServlet.startDownload((Document)document);
            this.printed(null);
        }).build();
        this.manager.runInteractive(job, Messages.get((String)"document.download.title"), Messages.get((String)"document.download.cancel"));
    }

    private DocumentPrinter getPrinter(PrinterReference reference) {
        return reference != null ? this.getPrinterLocator().getPrinter(reference.getArchetype(), reference.getId()) : null;
    }

    private <T> JobBuilder<T> newJob() {
        return JobBuilder.newJob(this.getDisplayName(), this.getContext().getUser());
    }
}

