/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.print;

import java.util.List;
import java.util.Objects;
import org.openvpms.archetype.rules.doc.PrinterReference;
import org.openvpms.web.component.bound.Binder;
import org.openvpms.web.component.bound.SelectFieldBinder;
import org.openvpms.web.component.print.PrinterField;
import org.openvpms.web.component.print.PrinterListModel;
import org.openvpms.web.component.property.Property;

public class BoundPrinterField
extends PrinterField {
    private final Binder binder;

    public BoundPrinterField(Property property) {
        this.binder = this.createBinder(property);
    }

    public BoundPrinterField(Property property, List<PrinterReference> printers) {
        super(printers);
        this.binder = this.createBinder(property);
    }

    public BoundPrinterField(Property property, PrinterListModel model) {
        super(model);
        this.binder = this.createBinder(property);
    }

    public void init() {
        super.init();
        this.binder.bind();
    }

    public void dispose() {
        super.dispose();
        this.binder.unbind();
    }

    private SelectFieldBinder createBinder(Property property) {
        return new SelectFieldBinder(this, property){

            @Override
            protected boolean setProperty(Property property) {
                PrinterReference propertyValue;
                PrinterReference fieldValue = (PrinterReference)this.getFieldValue();
                String value = fieldValue != null ? fieldValue.toString() : null;
                boolean result = property.setValue(value);
                if (result && !Objects.equals(fieldValue, propertyValue = PrinterReference.fromString((String)property.getString()))) {
                    this.setField();
                }
                return result;
            }

            @Override
            protected int indexOf(Object value) {
                if (value instanceof String) {
                    value = PrinterReference.fromString((String)((String)value));
                }
                return super.indexOf(value);
            }
        };
    }
}

