/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.prefs;

import java.util.Collections;
import java.util.Set;
import org.openvpms.archetype.rules.practice.PracticeService;
import org.openvpms.archetype.rules.prefs.PreferenceService;
import org.openvpms.archetype.rules.prefs.Preferences;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.model.user.User;
import org.openvpms.web.echo.util.WeakReferenceCallbacks;

public class UserPreferences
implements Preferences {
    private final PreferenceService service;
    private final PracticeService practiceService;
    private final WeakReferenceCallbacks listeners = new WeakReferenceCallbacks();
    private Preferences preferences;
    private Preferences persistent;
    private User user;

    public UserPreferences(PreferenceService service, PracticeService practiceService) {
        this.service = service;
        this.practiceService = practiceService;
    }

    public void initialise(User user) {
        this.user = user;
        this.refresh();
    }

    public void addListener(Runnable listener) {
        this.listeners.add(listener);
    }

    public void removeListener(Runnable listener) {
        this.listeners.remove(listener);
    }

    public void refresh() {
        if (this.user != null) {
            this.preferences = this.service.getPreferences((Party)this.user, this.practiceService.getPractice(), false);
            this.persistent = null;
            this.listeners.call();
        }
    }

    public Set<String> getGroupNames() {
        return this.preferences != null ? this.preferences.getGroupNames() : Collections.emptySet();
    }

    public Set<String> getNames(String groupName) {
        return this.preferences != null ? this.preferences.getNames(groupName) : Collections.emptySet();
    }

    public Object getPreference(String groupName, String name, Object defaultValue) {
        return this.preferences != null ? this.preferences.getPreference(groupName, name, defaultValue) : defaultValue;
    }

    public void setPreference(String groupName, String name, Object value) {
        this.setPreference(groupName, name, value, false);
    }

    public void setPreference(String groupName, String name, Object value, boolean save) {
        if (!save) {
            this.setSession(groupName, name, value);
        } else if (this.user != null) {
            Preferences persistent = this.getPersistent();
            persistent.setPreference(groupName, name, value);
            this.setSession(groupName, name, value);
        }
    }

    public boolean getBoolean(String groupName, String name, boolean defaultValue) {
        return this.preferences != null ? this.preferences.getBoolean(groupName, name, defaultValue) : defaultValue;
    }

    public int getInt(String groupName, String name, int defaultValue) {
        return this.preferences != null ? this.preferences.getInt(groupName, name, defaultValue) : defaultValue;
    }

    public long getLong(String groupName, String name, long defaultValue) {
        return this.preferences != null ? this.preferences.getLong(groupName, name, defaultValue) : defaultValue;
    }

    public String getString(String groupName, String name, String defaultValue) {
        return this.preferences != null ? this.preferences.getString(groupName, name, defaultValue) : defaultValue;
    }

    public Reference getReference(String groupName, String name, Reference defaultValue) {
        return this.preferences != null ? this.preferences.getReference(groupName, name, defaultValue) : defaultValue;
    }

    protected void setSession(String groupName, String name, Object value) {
        if (this.preferences != null) {
            this.preferences.setPreference(groupName, name, value);
        }
    }

    protected Preferences getPersistent() {
        if (this.persistent == null) {
            this.persistent = this.service.getPreferences((Party)this.user, this.practiceService.getPractice(), true);
        }
        return this.persistent;
    }
}

