/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.prefs;

import org.openvpms.archetype.rules.prefs.PreferenceService;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;
import org.openvpms.web.component.im.edit.AbstractIMObjectEditor;
import org.openvpms.web.component.im.edit.IMObjectEditor;
import org.openvpms.web.component.im.layout.AbstractLayoutStrategy;
import org.openvpms.web.component.im.layout.IMObjectLayoutStrategy;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.im.view.ComponentState;
import org.openvpms.web.component.prefs.PreferenceGroupCollectionEditor;
import org.openvpms.web.component.property.PropertySet;
import org.openvpms.web.echo.help.HelpContext;
import org.openvpms.web.system.ServiceHelper;

public class PreferencesEditor
extends AbstractIMObjectEditor {
    private final Party party;
    private final Party source;
    private final PreferenceGroupCollectionEditor groups;

    public PreferencesEditor(Party party, Party source, LayoutContext layoutContext) {
        super((IMObject)ServiceHelper.getBean(PreferenceService.class).getEntity(party, source), null, layoutContext);
        this.party = party;
        this.source = source;
        this.groups = new PreferenceGroupCollectionEditor(this.getCollectionProperty("groups"), (Entity)this.getObject(), this.getLayoutContext());
        this.addEditor(this.groups);
    }

    @Override
    public String getTitle() {
        return this.getDisplayName();
    }

    @Override
    public IMObjectEditor newInstance() {
        return new PreferencesEditor(this.party, this.source, this.getLayoutContext());
    }

    @Override
    public HelpContext getHelpContext() {
        IMObjectEditor selected = this.groups.getSelected();
        return selected != null ? selected.getHelpContext() : super.getHelpContext();
    }

    @Override
    protected IMObjectLayoutStrategy createLayoutStrategy() {
        return new AbstractLayoutStrategy(){

            @Override
            public ComponentState apply(IMObject object, PropertySet properties, IMObject parent, LayoutContext context) {
                return new ComponentState(PreferencesEditor.this.groups);
            }
        };
    }
}

