/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.prefs;

import nextapp.echo2.app.Component;
import nextapp.echo2.app.Label;
import org.openvpms.component.model.party.Party;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.help.HelpDialog;
import org.openvpms.web.component.help.HelpTopics;
import org.openvpms.web.component.im.edit.AbstractEditDialog;
import org.openvpms.web.component.im.edit.EditActions;
import org.openvpms.web.component.im.layout.DefaultLayoutContext;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.prefs.PreferencesEditor;
import org.openvpms.web.component.prefs.UserPreferences;
import org.openvpms.web.echo.factory.ColumnFactory;
import org.openvpms.web.echo.factory.LabelFactory;
import org.openvpms.web.echo.focus.FocusGroup;
import org.openvpms.web.echo.help.HelpContext;
import org.openvpms.web.echo.util.StyleSheetHelper;
import org.openvpms.web.system.ServiceHelper;

public class PreferencesDialog
extends AbstractEditDialog {
    private final boolean showPrompt;

    public PreferencesDialog(Party party, Party source, Context context) {
        this(party, source, false, context);
    }

    public PreferencesDialog(Party party, Party source, boolean showPrompt, Context context) {
        super(null, null, EditActions.okCancel(), context, PreferencesDialog.createHelpContext());
        this.showPrompt = showPrompt;
        DefaultLayoutContext layout = new DefaultLayoutContext(context, this.getHelpContext());
        PreferencesEditor editor = new PreferencesEditor(party, source, (LayoutContext)layout);
        this.setEditor(editor);
        this.resize("PreferencesDialog.size");
    }

    @Override
    public boolean save() {
        boolean save = super.save();
        if (save) {
            UserPreferences preferences = ServiceHelper.getBean(UserPreferences.class);
            preferences.refresh();
        }
        return save;
    }

    @Override
    public HelpContext getHelpContext() {
        return this.getEditor() != null ? this.getEditor().getHelpContext() : super.getHelpContext();
    }

    @Override
    protected void setComponent(Component component, FocusGroup group, HelpContext context) {
        if (this.showPrompt) {
            Label label = LabelFactory.create((String)"admin.user.prefs.edit.message", (String)"bold");
            component = ColumnFactory.create((String)"CellSpacing", (Component[])new Component[]{ColumnFactory.create((String)"Inset", (Component[])new Component[]{label}), component});
        }
        super.setComponent(component, group, context);
    }

    protected static HelpContext createHelpContext() {
        return new HelpContext("entity.preferences/edit", help -> {
            String features = StyleSheetHelper.getProperty((String)"HelpBrowser.features");
            HelpDialog.show(help, ServiceHelper.getBean(HelpTopics.class), features);
        });
    }
}

