/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.mail;

import java.util.List;
import org.openvpms.component.model.party.Contact;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.mail.AddressFormatter;
import org.openvpms.web.component.mail.AddressSelector;
import org.openvpms.web.component.mail.MultiContactSelector;
import org.openvpms.web.component.property.Modifiable;
import org.openvpms.web.component.property.Validator;
import org.openvpms.web.component.property.ValidatorError;
import org.openvpms.web.resource.i18n.Messages;

public class ToAddressSelector
extends AddressSelector {
    private final String key;
    private final MultiContactSelector selector;

    public ToAddressSelector(List<Contact> contacts, AddressFormatter formatter, LayoutContext context, String key) {
        super(contacts, formatter);
        this.selector = new MultiContactSelector(formatter, context);
        this.setField(this.selector.getTextField());
        this.key = key;
    }

    @Override
    public void setSelected(Contact contact) {
        super.setSelected(contact);
        this.selector.setObject(contact);
    }

    public void setSelected(List<Contact> contacts) {
        if (contacts.isEmpty()) {
            this.setSelected((Contact)null);
        } else {
            this.setSelected(contacts.get(0));
            this.selector.setObjects(contacts);
        }
    }

    @Override
    public Contact getSelected() {
        List objects = this.selector.getObjects();
        return !objects.isEmpty() ? (Contact)objects.get(0) : null;
    }

    public String[] getAddresses() {
        String[] result = null;
        if (this.selector.isValid()) {
            List contacts = this.selector.getObjects();
            String[] stringArray = result = !contacts.isEmpty() ? new String[contacts.size()] : null;
            if (result != null) {
                AddressFormatter formatter = this.getFormatter();
                for (int i = 0; i < contacts.size(); ++i) {
                    result[i] = formatter.getNameAddress((Contact)contacts.get(i), true);
                }
            }
        }
        return result;
    }

    @Override
    protected boolean doValidation(Validator validator) {
        String name;
        boolean valid = this.selector.isValid();
        if (!valid && (name = this.selector.getFirstNotFound()) != null) {
            validator.add((Modifiable)this, new ValidatorError(Messages.format((String)"mail.notfound", (Object[])new Object[]{Messages.get((String)this.key), name})));
        }
        return valid;
    }
}

