/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.mail;

import java.util.Set;
import nextapp.echo2.app.event.WindowPaneListener;
import org.openvpms.archetype.rules.doc.EmailTemplate;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.component.system.common.util.Variables;
import org.openvpms.report.ParameterType;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.im.doc.ParameterDialog;
import org.openvpms.web.component.im.report.Reporter;
import org.openvpms.web.component.macro.MacroVariables;
import org.openvpms.web.component.mail.EmailTemplateEvaluator;
import org.openvpms.web.component.util.ErrorHelper;
import org.openvpms.web.echo.dialog.PopupDialogListener;
import org.openvpms.web.echo.help.HelpContext;
import org.openvpms.web.resource.i18n.Messages;
import org.openvpms.web.system.ServiceHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParameterEmailTemplateEvaluator {
    private final EmailTemplate template;
    private final Context context;
    private final HelpContext help;
    private final EmailTemplateEvaluator evaluator;
    private static final Logger log = LoggerFactory.getLogger(ParameterEmailTemplateEvaluator.class);

    public ParameterEmailTemplateEvaluator(EmailTemplate template, Context context, HelpContext help) {
        this.template = template;
        this.context = context;
        this.evaluator = ServiceHelper.getBean(EmailTemplateEvaluator.class);
        this.help = help;
    }

    public void evaluate(Object object, boolean prompt, Listener listener) {
        try {
            Reporter<IMObject> reporter;
            Reporter<IMObject> reporter2 = reporter = prompt ? this.evaluator.getMessageReporter(this.template, object, this.context) : null;
            if (reporter != null) {
                Set<ParameterType> parameters = reporter.getParameterTypes();
                if (!parameters.isEmpty()) {
                    this.promptParameters(reporter, object, listener);
                } else {
                    this.generate(reporter, object, listener);
                }
            } else {
                String subject = this.evaluator.getSubject(this.template, object, this.context);
                String message = this.evaluator.getMessage(this.template, object, this.context);
                listener.generated(subject, message);
            }
        }
        catch (Throwable exception) {
            this.error(exception);
        }
    }

    private void generate(Reporter<IMObject> reporter, Object object, Listener listener) {
        try {
            String subject = this.evaluator.getSubject(this.template, object, this.context);
            String message = this.evaluator.getMessage(reporter);
            listener.generated(subject, message);
        }
        catch (Throwable exception) {
            this.error(exception);
        }
    }

    private void promptParameters(final Reporter<IMObject> reporter, final Object object, final Listener listener) {
        Set<ParameterType> parameters = reporter.getParameterTypes();
        String title = Messages.format((String)"document.input.parameters", (Object[])new Object[]{this.template.getName()});
        MacroVariables variables = new MacroVariables(this.context, (ArchetypeService)ServiceHelper.getArchetypeService(), ServiceHelper.getLookupService());
        IMObject obj = object instanceof IMObject ? (IMObject)object : null;
        final ParameterDialog dialog = new ParameterDialog(title, parameters, obj, this.context, this.help.subtopic("parameters"), (Variables)variables, false, true);
        dialog.addWindowPaneListener((WindowPaneListener)new PopupDialogListener(){

            public void onOK() {
                reporter.setParameters(dialog.getValues());
                ParameterEmailTemplateEvaluator.this.generate(reporter, object, listener);
            }
        });
        dialog.show();
    }

    private void error(Throwable exception) {
        ErrorHelper.show(Messages.format((String)"mail.template.error", (Object[])new Object[]{this.template.getName(), exception.getMessage()}));
        log.error("Failed to expand email template: " + this.template.getName(), exception);
    }

    public static interface Listener {
        public void generated(String var1, String var2);
    }
}

