/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.mail;

import java.util.List;
import org.openvpms.component.model.party.Contact;
import org.openvpms.web.component.mail.AddressFormatter;
import org.openvpms.web.component.mail.AddressSelector;
import org.openvpms.web.component.property.Modifiable;
import org.openvpms.web.component.property.Validator;
import org.openvpms.web.component.property.ValidatorError;
import org.openvpms.web.echo.factory.TextComponentFactory;
import org.openvpms.web.resource.i18n.Messages;

public class FromAddressSelector
extends AddressSelector {
    private Contact selected;

    public FromAddressSelector(List<Contact> contacts, AddressFormatter formatter) {
        super(contacts, formatter, TextComponentFactory.create((int)40));
        this.getField().setEnabled(false);
    }

    @Override
    public void setSelected(Contact contact) {
        super.setSelected(contact);
        this.selected = contact;
        this.getField().setText(contact != null ? this.getFormatter().getNameAddress(contact, false) : null);
    }

    @Override
    public Contact getSelected() {
        return this.selected;
    }

    @Override
    protected boolean doValidation(Validator validator) {
        boolean valid = false;
        if (this.selected != null) {
            valid = true;
        } else {
            validator.add((Modifiable)this, new ValidatorError(Messages.get((String)"mail.nofromaddress")));
        }
        return valid;
    }
}

