/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.mail;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import nextapp.echo2.app.Column;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.ListBox;
import nextapp.echo2.app.event.ActionEvent;
import nextapp.echo2.app.event.DocumentEvent;
import nextapp.echo2.app.list.ListCellRenderer;
import org.apache.commons.lang3.StringUtils;
import org.openvpms.component.business.service.archetype.rule.IArchetypeRuleService;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Contact;
import org.openvpms.web.component.mail.AddressFormatter;
import org.openvpms.web.component.mail.EmailAddress;
import org.openvpms.web.component.mail.EmailCellRenderer;
import org.openvpms.web.component.property.AbstractModifiable;
import org.openvpms.web.component.property.ErrorListener;
import org.openvpms.web.component.property.ModifiableListener;
import org.openvpms.web.component.property.ModifiableListeners;
import org.openvpms.web.echo.event.ActionListener;
import org.openvpms.web.echo.event.DocumentListener;
import org.openvpms.web.echo.factory.ListBoxFactory;
import org.openvpms.web.echo.popup.DropDown;
import org.openvpms.web.echo.style.Styles;
import org.openvpms.web.echo.text.TextField;
import org.openvpms.web.system.ServiceHelper;

public abstract class AddressSelector
extends AbstractModifiable {
    private final List<Contact> contacts;
    private final AddressFormatter formatter;
    private final ModifiableListeners listeners = new ModifiableListeners();
    private final Component container;
    private TextField field;
    private DropDown dropDown;
    private ListBox listBox;
    private boolean modified = false;

    protected AddressSelector(List<Contact> contacts, AddressFormatter formatter) {
        this(contacts, formatter, null);
    }

    public AddressSelector(List<Contact> contacts, AddressFormatter formatter, TextField field) {
        this.contacts = new ArrayList<Contact>(contacts);
        this.formatter = formatter;
        this.container = new Column();
        this.setField(field);
        if (!contacts.isEmpty()) {
            this.createContactDropDown();
        }
    }

    public void setSelected(Contact contact) {
        this.resetValid();
        if (this.listBox != null) {
            int size = this.listBox.getModel().size();
            boolean found = false;
            if (contact != null) {
                for (int i = 0; i < size; ++i) {
                    if (!Objects.equals(contact, this.listBox.getModel().get(i))) continue;
                    this.listBox.setSelectedIndex(i);
                    found = true;
                    break;
                }
            }
            if (!found) {
                this.listBox.getSelectionModel().clearSelection();
            }
        }
    }

    public void addContact(Contact contact) {
        this.contacts.add(contact);
        this.createContactDropDown();
    }

    public abstract Contact getSelected();

    public String getAddress() {
        Contact selected = this.getSelected();
        return selected != null ? this.getFormatter().getAddress(selected) : null;
    }

    public String getNameAddress() {
        Contact selected = this.getSelected();
        return selected != null ? this.getFormatter().getNameAddress(selected, true) : null;
    }

    public TextField getField() {
        return this.field;
    }

    public AddressFormatter getFormatter() {
        return this.formatter;
    }

    public Component getComponent() {
        return this.container;
    }

    @Override
    public boolean isModified() {
        return this.modified;
    }

    @Override
    public void clearModified() {
        this.modified = false;
    }

    @Override
    public void addModifiableListener(ModifiableListener listener) {
        this.listeners.addListener(listener);
    }

    @Override
    public void addModifiableListener(ModifiableListener listener, int index) {
        this.listeners.addListener(listener, index);
    }

    @Override
    public void removeModifiableListener(ModifiableListener listener) {
        this.listeners.removeListener(listener);
    }

    @Override
    public void setErrorListener(ErrorListener listener) {
    }

    @Override
    public ErrorListener getErrorListener() {
        return null;
    }

    public static Contact getContact(List<Contact> contacts, String address) {
        EmailAddress emailAddress = EmailAddress.parse(address);
        if (emailAddress != null) {
            address = emailAddress.getAddress();
            for (Contact contact : contacts) {
                IMObjectBean bean = ServiceHelper.getArchetypeService().getBean((IMObject)contact);
                if (!StringUtils.equalsIgnoreCase((CharSequence)address, (CharSequence)bean.getString("emailAddress"))) continue;
                return contact;
            }
        }
        return null;
    }

    public static Contact createContact(String address) {
        EmailAddress parsed = EmailAddress.parse(address);
        return parsed != null ? AddressSelector.createContact(parsed) : null;
    }

    public static Contact createContact(EmailAddress address) {
        IArchetypeRuleService service = ServiceHelper.getArchetypeService();
        Contact contact = (Contact)service.create("contact.email", Contact.class);
        String name = address.getName();
        if (name != null) {
            contact.setName(name);
        }
        IMObjectBean bean = service.getBean((IMObject)contact);
        bean.setValue("emailAddress", (Object)address.getAddress());
        return contact;
    }

    protected void setField(TextField field) {
        this.field = field;
        if (field != null) {
            field.setWidth(Styles.FULL_WIDTH);
            if (this.dropDown != null) {
                this.dropDown.setTarget((Component)field);
            } else {
                this.setComponent((Component)field);
            }
            field.getDocument().addDocumentListener((nextapp.echo2.app.event.DocumentListener)new DocumentListener(){

                public void onUpdate(DocumentEvent event) {
                    AddressSelector.this.onModified();
                }
            });
        }
    }

    protected void onModified() {
        this.modified = true;
        this.listeners.notifyListeners(this);
    }

    private void createContactDropDown() {
        this.listBox = ListBoxFactory.create(this.contacts);
        this.listBox.getSelectionModel().clearSelection();
        this.listBox.setWidth(Styles.FULL_WIDTH);
        this.listBox.setCellRenderer((ListCellRenderer)new EmailCellRenderer(this.formatter));
        this.dropDown = new DropDown();
        this.dropDown.setWidth(Styles.FULL_WIDTH);
        if (this.field != null) {
            this.dropDown.setTarget((Component)this.field);
        }
        this.dropDown.setPopUpAlwaysOnTop(true);
        this.dropDown.setFocusOnExpand(true);
        this.dropDown.setFocusComponent((Component)this.listBox);
        this.dropDown.setPopUp((Component)this.listBox);
        this.listBox.addActionListener((nextapp.echo2.app.event.ActionListener)new ActionListener(){

            public void onAction(ActionEvent event) {
                AddressSelector.this.setSelected((Contact)AddressSelector.this.listBox.getSelectedValue());
                AddressSelector.this.dropDown.setExpanded(false);
            }
        });
        this.setComponent((Component)this.dropDown);
    }

    private void setComponent(Component component) {
        this.container.removeAll();
        this.container.add(component);
    }
}

