/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.mail;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;
import org.apache.commons.lang3.StringUtils;
import org.openvpms.archetype.rules.doc.DocumentHandler;
import org.openvpms.archetype.rules.doc.DocumentHandlers;
import org.openvpms.component.exception.OpenVPMSException;
import org.openvpms.component.model.document.Document;
import org.openvpms.web.component.mail.MailContext;
import org.openvpms.web.component.mail.MailException;
import org.openvpms.web.component.mail.Mailer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.mail.javamail.JavaMailSender;
import org.springframework.mail.javamail.MimeMessageHelper;

public abstract class AbstractMailer
implements Mailer {
    private final MailContext context;
    private final JavaMailSender sender;
    private final DocumentHandlers handlers;
    private final List<Document> attachments = new ArrayList<Document>();
    private String from;
    private String[] to;
    private String[] cc;
    private String[] bcc;
    private String subject;
    private String body;
    private static final Logger log = LoggerFactory.getLogger(AbstractMailer.class);

    public AbstractMailer(MailContext context, JavaMailSender sender, DocumentHandlers handlers) {
        this.context = context;
        this.sender = sender;
        this.handlers = handlers;
    }

    @Override
    public MailContext getContext() {
        return this.context;
    }

    @Override
    public void setFrom(String from) {
        this.from = from;
    }

    @Override
    public String getFrom() {
        return this.from;
    }

    @Override
    public void setTo(String[] to) {
        this.to = to;
    }

    @Override
    public String[] getTo() {
        return this.to;
    }

    @Override
    public void setCc(String[] cc) {
        this.cc = cc;
    }

    @Override
    public String[] getCc() {
        return this.cc;
    }

    @Override
    public void setBcc(String[] bcc) {
        this.bcc = bcc;
    }

    @Override
    public String[] getBcc() {
        return this.bcc;
    }

    @Override
    public void setSubject(String subject) {
        this.subject = subject;
    }

    @Override
    public String getSubject() {
        return this.subject;
    }

    @Override
    public void setBody(String body) {
        this.body = body;
    }

    @Override
    public String getBody() {
        return this.body;
    }

    @Override
    public void addAttachment(Document document) {
        this.attachments.add(document);
    }

    @Override
    public List<Document> getAttachments() {
        return this.attachments;
    }

    @Override
    public void send() {
        MimeMessage message = this.sender.createMimeMessage();
        try {
            MimeMessageHelper helper = this.createHelper(message);
            this.populateMessage(helper);
            if (log.isDebugEnabled()) {
                this.log(message);
            }
            this.sender.send(message);
        }
        catch (OpenVPMSException exception) {
            throw exception;
        }
        catch (Throwable exception) {
            String address = this.to != null ? StringUtils.join((Object[])this.to, (String)", ") : null;
            throw new MailException(MailException.ErrorCode.FailedToSend, address, exception.getMessage());
        }
    }

    protected MimeMessageHelper createHelper(MimeMessage message) throws MessagingException {
        MimeMessageHelper helper = new MimeMessageHelper(message, true, "UTF-8");
        helper.setValidateAddresses(true);
        return helper;
    }

    protected void populateMessage(MimeMessageHelper helper) throws MessagingException {
        String[] bcc;
        String[] cc;
        helper.setFrom(this.getFrom());
        helper.setReplyTo(this.getFrom());
        String[] to = this.getTo();
        if (to != null && to.length != 0) {
            helper.setTo(to);
        }
        if ((cc = this.getCc()) != null && cc.length != 0) {
            helper.setCc(cc);
        }
        if ((bcc = this.getBcc()) != null && bcc.length != 0) {
            helper.setBcc(bcc);
        }
        helper.setSubject(this.getSubject());
        if (this.body != null) {
            helper.setText(this.body, true);
        } else {
            helper.setText("");
        }
        for (Document attachment : this.attachments) {
            this.addAttachment(helper, attachment);
        }
    }

    protected void addAttachment(MimeMessageHelper helper, Document document) throws MessagingException {
        DocumentHandler handler = this.handlers.get(document.getName(), document.getArchetype(), document.getMimeType());
        helper.addAttachment(document.getName(), () -> handler.getContent(document));
    }

    private void log(MimeMessage message) {
        try {
            StringBuilder builder = new StringBuilder("Sending mail: ");
            Enumeration headers = message.getAllHeaderLines();
            boolean first = true;
            while (headers.hasMoreElements()) {
                if (!first) {
                    builder.append(", ");
                } else {
                    first = false;
                }
                builder.append((String)headers.nextElement());
            }
            log.debug(builder.toString());
        }
        catch (Throwable exception) {
            log.debug("Cannot get mail headers", exception);
        }
    }
}

