/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.job;

import echopointng.ProgressBar;
import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.function.Supplier;
import nextapp.echo2.app.ApplicationInstance;
import nextapp.echo2.app.Color;
import nextapp.echo2.app.Column;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.Label;
import nextapp.echo2.app.TaskQueueHandle;
import nextapp.echo2.webcontainer.ContainerContext;
import org.apache.commons.lang3.concurrent.BasicThreadFactory;
import org.openvpms.component.business.service.security.RunAs;
import org.openvpms.component.model.user.User;
import org.openvpms.web.component.job.Job;
import org.openvpms.web.component.job.JobThread;
import org.openvpms.web.echo.dialog.MessageDialog;
import org.openvpms.web.echo.factory.ColumnFactory;
import org.openvpms.web.echo.factory.LabelFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;

public abstract class JobManager
implements DisposableBean {
    private final int timeout;
    private final Set<JobFuture<?>> futures = Collections.synchronizedSet(new HashSet());
    private final ExecutorService executor;
    private static final Logger log = LoggerFactory.getLogger(JobManager.class);
    private static final String COMPLETION_LISTENER = "CompletionListener";
    private static final String CANCELLATION_LISTENER = "CancellationListener";
    private static final String FAILURE_LISTENER = "FailureListener";

    public JobManager() {
        this(1000, "Job-%d");
    }

    public JobManager(int timeout, String namingPattern) {
        this.timeout = timeout;
        BasicThreadFactory factory = new BasicThreadFactory.Builder().namingPattern(namingPattern).daemon(true).build();
        this.executor = Executors.newCachedThreadPool((ThreadFactory)factory);
    }

    public <T> Future<T> run(Job<T> job) {
        JobHandle<T> handle = new JobHandle<T>(job);
        CompletableFuture<T> future = CompletableFuture.supplyAsync(handle, this.executor);
        JobFuture jobFuture = new JobFuture(handle, future);
        this.futures.add(jobFuture);
        future.whenComplete((result, throwable) -> this.whenCompleted(job, jobFuture, (Object)result, (Throwable)throwable));
        return jobFuture;
    }

    public <T> Future<T> runInteractive(Job<T> job, String title, String message) {
        State state = new State(ApplicationInstance.getActive());
        JobHandle<T> handle = new JobHandle<T>(job);
        CompletableFuture<T> future = CompletableFuture.supplyAsync(handle, this.executor);
        JobFuture jobFuture = new JobFuture(handle, future);
        this.futures.add(jobFuture);
        CancelDialog dialog = new CancelDialog(jobFuture, title, message, state);
        future.whenComplete((result, throwable) -> this.whenCompleted(job, state, jobFuture, dialog, (Object)result, (Throwable)throwable));
        try {
            jobFuture.get(this.timeout, TimeUnit.MILLISECONDS);
        }
        catch (TimeoutException exception) {
            dialog.showUnlessTaskFinished();
        }
        catch (Throwable throwable2) {
            // empty catch block
        }
        return jobFuture;
    }

    public void destroy() {
        this.executor.shutdown();
    }

    protected void queueListener(State state, Runnable listener) {
        state.runOrQueue(listener);
    }

    private <T> void whenCompleted(Job<T> job, JobFuture<T> future, T result, Throwable throwable) {
        this.futures.remove(future);
        if (throwable != null && !future.isCancelled()) {
            this.jobFailed(job, this.getCause(throwable));
        } else if (future.isDone() && !future.isCancelled()) {
            this.jobCompleted(job, result);
        } else {
            this.jobCancelled(job);
        }
    }

    private <T> void whenCompleted(Job<T> job, State state, JobFuture<T> future, CancelDialog dialog, T result, Throwable throwable) {
        this.futures.remove(future);
        dialog.scheduleClose();
        if (throwable != null && !future.isCancelled()) {
            this.interactiveJobFailed(job, this.getCause(throwable), state);
        } else if (future.isDone() && !future.isCancelled()) {
            this.interactiveJobCompleted(job, result, state);
        } else {
            this.interactiveJobCancelled(job, state);
        }
    }

    private Throwable getCause(Throwable exception) {
        if (exception instanceof CompletionException && exception.getCause() != null) {
            exception = exception.getCause();
        }
        return exception;
    }

    private void jobCompleted(Job<?> job, Object result) {
        Consumer<?> listener = job.getCompletionListener();
        if (listener != null) {
            Runnable command = () -> listener.accept(result);
            this.runProtected(command, job, COMPLETION_LISTENER);
        }
    }

    private void jobCancelled(Job<?> job) {
        Runnable listener = job.getCancellationListener();
        if (listener != null) {
            this.runProtected(listener, job, CANCELLATION_LISTENER);
        }
    }

    private void interactiveJobCompleted(Job<?> job, Object result, State state) {
        Consumer<?> listener = job.getCompletionListener();
        if (listener != null) {
            Runnable command = () -> listener.accept(result);
            this.queueListener(command, job, state, COMPLETION_LISTENER);
        } else {
            state.queueDispose();
        }
    }

    private void interactiveJobCancelled(Job<?> job, State state) {
        Runnable listener = job.getCancellationListener();
        if (listener != null) {
            this.queueListener(listener, job, state, CANCELLATION_LISTENER);
        } else {
            state.queueDispose();
        }
    }

    private void interactiveJobFailed(Job<?> job, Throwable exception, State state) {
        Consumer<Throwable> listener = job.getFailureListener();
        String username = this.getUserName(job);
        if (listener != null) {
            Runnable command = () -> listener.accept(exception);
            this.queueListener(command, job, state, FAILURE_LISTENER);
        } else {
            log.warn("Job {} run by {} failed with exception {}", new Object[]{job.getName(), username, exception.getMessage(), exception});
            state.queueDispose();
        }
    }

    private void queueListener(Runnable listener, Job<?> job, State state, String listenerName) {
        Runnable command = () -> {
            this.runProtected(listener, job, listenerName);
            state.dispose();
        };
        this.queueListener(state, command);
    }

    private void runProtected(Runnable listener, Job<?> job, String listenerName) {
        try {
            listener.run();
        }
        catch (Throwable exception) {
            String username = this.getUserName(job);
            log.error("{} for Job {} run by {} failed with exception {}", new Object[]{listenerName, job.getName(), username, exception.getMessage(), exception});
        }
    }

    private void jobFailed(Job<?> job, Throwable exception) {
        Consumer<Throwable> listener = job.getFailureListener();
        String username = this.getUserName(job);
        if (listener != null) {
            Runnable command = () -> listener.accept(exception);
            this.runProtected(command, job, FAILURE_LISTENER);
        } else {
            log.warn("Job {} run by {} failed with exception {}", new Object[]{job.getName(), username, exception.getMessage(), exception});
        }
    }

    private String getUserName(Job<?> job) {
        User user = job.getUser();
        return user != null ? user.getUsername() : "<unknown>";
    }

    private static class JobFuture<T>
    implements Future<T> {
        private final JobHandle<T> job;
        private final Future<T> future;

        private JobFuture(JobHandle<T> job, Future<T> future) {
            this.job = job;
            this.future = future;
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            if (!this.isDone()) {
                this.job.cancel();
            }
            return this.future.cancel(mayInterruptIfRunning);
        }

        @Override
        public boolean isCancelled() {
            return this.future.isCancelled();
        }

        @Override
        public boolean isDone() {
            return this.future.isDone();
        }

        @Override
        public T get() throws InterruptedException, ExecutionException {
            return this.future.get();
        }

        @Override
        public T get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            return this.future.get(timeout, unit);
        }
    }

    private static class JobHandle<T>
    implements Supplier<T>,
    JobThread {
        private final Job<T> job;
        private final Supplier<T> jobWithContext;
        private final Object lock = new Object();
        private Thread thread;

        public JobHandle(Job<T> job) {
            this.job = job;
            this.jobWithContext = RunAs.inheritSecurityContext(job);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public T get() {
            Object object = this.lock;
            synchronized (object) {
                this.thread = Thread.currentThread();
            }
            try {
                object = this.jobWithContext.get();
                return (T)object;
            }
            finally {
                Object object2 = this.lock;
                synchronized (object2) {
                    this.thread = null;
                }
            }
        }

        public void cancel() {
            try {
                this.job.cancel(this);
            }
            catch (Throwable exception) {
                log.debug("cancel() threw exception for job={}: {}", new Object[]{this.job.getName(), exception.getMessage(), exception});
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void interrupt() {
            Object object = this.lock;
            synchronized (object) {
                if (this.thread != null && this.thread != Thread.currentThread()) {
                    this.thread.interrupt();
                }
            }
        }
    }

    static class CancelDialog
    extends MessageDialog {
        private final Future<?> future;
        private final ProgressBar bar;
        private final State state;
        private final Object lock = new Object();
        private boolean closed;
        private boolean shown;

        public CancelDialog(Future<?> future, String title, String message, State state) {
            super(title, message, CANCEL);
            this.future = future;
            this.bar = new ProgressBar();
            this.bar.setCompletedColor(Color.GREEN);
            this.bar.setNumberOfBlocks(10);
            this.state = state;
            this.setDefaultCloseAction(null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void showUnlessTaskFinished() {
            Object object = this.lock;
            synchronized (object) {
                if (!this.closed) {
                    this.shown = true;
                    this.show();
                }
            }
        }

        public void show() {
            this.queueRefresh();
            super.show();
        }

        public void userClose() {
            this.shown = false;
            if (this.getParent() != null) {
                super.userClose();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void scheduleClose() {
            Object object = this.lock;
            synchronized (object) {
                this.closed = true;
                if (this.shown) {
                    this.state.runOrQueue(this::userClose);
                }
            }
        }

        protected void doLayout() {
            Label content = LabelFactory.text((String)this.getMessage(), (boolean)true);
            Column column = ColumnFactory.create((String)"WideCellSpacing", (Component[])new Component[]{content, this.bar});
            this.getLayout().add((Component)ColumnFactory.create((String)"Inset.Large", (Component[])new Component[]{column}));
        }

        protected void doCancel() {
            if (!this.future.isDone()) {
                this.future.cancel(true);
            }
            super.doCancel();
        }

        protected void queueRefresh() {
            this.state.queue(this::refresh);
        }

        protected void refresh() {
            if (!this.future.isDone() && !this.future.isCancelled()) {
                this.advance();
                this.queueRefresh();
            } else {
                this.userClose();
            }
        }

        private void advance() {
            int value = this.bar.getValue() + 1;
            if (value > this.bar.getMaximum()) {
                value = this.bar.getMinimum();
            }
            this.bar.setValue(value);
        }
    }

    protected static class State {
        private final WeakReference<ApplicationInstance> appRef;
        private final AtomicInteger queued = new AtomicInteger();
        private WeakReference<TaskQueueHandle> taskQueueRef;

        public State(ApplicationInstance app) {
            this.appRef = new WeakReference<ApplicationInstance>(app);
            TaskQueueHandle taskQueue = app.createTaskQueue();
            this.taskQueueRef = new WeakReference<TaskQueueHandle>(taskQueue);
            ContainerContext context = (ContainerContext)app.getContextProperty(ContainerContext.CONTEXT_PROPERTY_NAME);
            if (context != null) {
                context.setTaskQueueCallbackInterval(taskQueue, 500);
            }
            this.taskQueueRef = new WeakReference<TaskQueueHandle>(taskQueue);
        }

        public void runOrQueue(Runnable task) {
            if (this.isUIThread()) {
                task.run();
            } else {
                this.queue(task);
            }
        }

        public void queue(Runnable task) {
            ApplicationInstance app = (ApplicationInstance)this.appRef.get();
            TaskQueueHandle taskQueue = (TaskQueueHandle)this.taskQueueRef.get();
            if (app != null && taskQueue != null) {
                this.queued.incrementAndGet();
                Runnable wrapper = () -> {
                    try {
                        task.run();
                    }
                    finally {
                        this.queued.decrementAndGet();
                    }
                };
                app.enqueueTask(taskQueue, wrapper);
            }
        }

        public boolean isUIThread() {
            ApplicationInstance app = (ApplicationInstance)this.appRef.get();
            return app != null && app == ApplicationInstance.getActive();
        }

        public void dispose() {
            ApplicationInstance app = (ApplicationInstance)this.appRef.get();
            TaskQueueHandle taskQueue = (TaskQueueHandle)this.taskQueueRef.get();
            if (app != null && taskQueue != null) {
                app.removeTaskQueue(taskQueue);
            }
            this.appRef.clear();
            this.taskQueueRef.clear();
        }

        public void queueDispose() {
            if (this.queued.get() > 0) {
                this.queue(this::dispose);
            } else {
                this.dispose();
            }
        }
    }
}

