/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.im.view;

import java.math.BigDecimal;
import java.util.Date;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.Label;
import org.apache.commons.lang3.StringUtils;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.web.component.app.ContextSwitchListener;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.im.util.IMObjectNames;
import org.openvpms.web.component.im.util.LookupNameHelper;
import org.openvpms.web.component.im.view.AbstractReadOnlyComponentFactory;
import org.openvpms.web.component.im.view.Hint;
import org.openvpms.web.component.im.view.IMObjectReferenceViewer;
import org.openvpms.web.component.im.view.layout.TableLayoutStrategyFactory;
import org.openvpms.web.component.property.Property;
import org.openvpms.web.component.util.NumericPropertyFormatter;
import org.openvpms.web.echo.factory.LabelFactory;
import org.openvpms.web.echo.factory.RowFactory;
import org.openvpms.web.echo.table.TableHelper;
import org.openvpms.web.echo.util.StyleSheetHelper;
import org.openvpms.web.resource.i18n.format.DateFormatter;
import org.openvpms.web.system.ServiceHelper;

public class TableComponentFactory
extends AbstractReadOnlyComponentFactory {
    private boolean truncateLongText;
    private int maxLength = 30;
    private static final int MAX_LENGTH = 30;
    private static final int MIN_LENGTH = 5;

    public TableComponentFactory(LayoutContext context) {
        super(context, new TableLayoutStrategyFactory((ArchetypeService)ServiceHelper.getArchetypeService()), "default");
    }

    public void setTruncateLongText(boolean truncate) {
        this.truncateLongText = truncate;
        if (this.truncateLongText) {
            this.maxLength = StyleSheetHelper.getProperty((String)"table.text.maxlength", (int)30);
            if (this.maxLength < 5) {
                this.maxLength = 5;
            }
        }
    }

    @Override
    protected Component createLookup(Property property, IMObject context) {
        String name = LookupNameHelper.getName(context, property.getName());
        return this.createLabel(name, false);
    }

    @Override
    protected Component createString(Property property, Hint hint) {
        return this.createLabel(property, hint != null && hint.isMultiline());
    }

    @Override
    protected Component createNumeric(Property property) {
        String value = this.getNumericValue(property);
        return TableHelper.rightAlign((String)value);
    }

    @Override
    protected Component createDate(Property property) {
        String value = this.getDateValue(property);
        Label label = LabelFactory.create();
        label.setText(value);
        return label;
    }

    protected String getNumericValue(Property property) {
        Object tmp = property.getValue();
        Number value = tmp instanceof String ? new BigDecimal((String)tmp) : (Number)tmp;
        if (value != null) {
            return NumericPropertyFormatter.format(value, property, false);
        }
        return null;
    }

    protected String getDateValue(Property property) {
        Date value = (Date)property.getValue();
        return value != null ? DateFormatter.formatDate((Date)value, (boolean)false) : null;
    }

    @Override
    protected Component createBoolean(Property property) {
        return RowFactory.create((Component[])new Component[]{RowFactory.create((Component[])new Component[]{super.createBoolean(property)})});
    }

    @Override
    protected Component getEmptyCollectionViewer() {
        return LabelFactory.create();
    }

    @Override
    protected Label createLabel(String text, boolean multiline) {
        Label label = LabelFactory.create((boolean)multiline);
        if (this.truncateLongText && text != null && text.length() > this.maxLength) {
            label.setText(StringUtils.abbreviateMiddle((String)text, (String)"...", (int)this.maxLength));
            label.setToolTipText(text);
        } else {
            label.setText(text);
        }
        return label;
    }

    @Override
    protected Component getObjectViewer(Reference reference, ContextSwitchListener listener, LayoutContext layout) {
        String tooltip = null;
        IMObjectNames names = layout.getNames();
        String name = names.getName(reference);
        if (this.truncateLongText && name != null && name.length() > this.maxLength) {
            tooltip = name;
            name = StringUtils.abbreviateMiddle((String)name, (String)"...", (int)this.maxLength);
        }
        return new IMObjectReferenceViewer(reference, name, tooltip, listener, layout.getContext()).getComponent();
    }
}

